/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.util;

import com.zerog.ia.installer.util.BidiUtilBase;
import com.zerog.ia.installer.util.MnemonicString;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionListener;
import java.text.Bidi;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

public class BidiUtilImpl
extends BidiUtilBase {
    private static final String LRM = "\u200e";
    private static final String PDF = "\u202c";
    private static final String RLM = "\u200f";
    private static final char LRO = '\u202d';
    private static final char ISOLATED_HAMZA = '\u0621';
    private static final char SHAPED_HAMZA = '\ufe80';
    private static final char ARABIC_QUESTION_MARK = '\u061f';
    private static final char ARABIC_FULL_STOP = '\u06d4';
    private static final char ARABIC_COMMA = '\u060c';

    public Locale getDefaultLocale() {
        return JComponent.getDefaultLocale();
    }

    public void setDefaultLocale(Locale locale) {
        JComponent.setDefaultLocale(locale);
    }

    public void applyComponentOrientation(Component component) {
        this.applyComponentOrientation(component, this.a());
    }

    public void applyComponentOrientation(Component component, ComponentOrientation componentOrientation) {
        component.applyComponentOrientation(componentOrientation);
    }

    public String applyTextOrientation(String string, ComponentOrientation componentOrientation) {
        if (string == null || string.equals("") || string.charAt(0) == '\u202d' || string.length() < 2 || ZeroGbb.b().c(string)) {
            return string;
        }
        if (componentOrientation.isLeftToRight()) {
            return BidiUtilImpl.characterIsLTR(string.charAt(0)) ? string : '\u202a' + string;
        }
        if (!BidiUtilImpl.characterIsRTL(string.charAt(0))) {
            String string2 = "\n";
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = string.split(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() != 0) {
                    stringBuffer.append('\u202b' + stringArray[i]);
                    stringBuffer.append("\n");
                    continue;
                }
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public void drawText(Graphics graphics, int n, int n2, String string, Component component) {
        if (graphics == null || string == null || component == null || string.length() < 1) {
            return;
        }
        Bidi bidi = new Bidi(string, component.getComponentOrientation().isLeftToRight() ? 0 : 1);
        int n3 = bidi.getRunCount();
        if (n3 > 1) {
            int n4;
            byte[] byArray = new byte[n3];
            Object[] objectArray = new String[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                objectArray[n4] = string.substring(bidi.getRunStart(n4), bidi.getRunLimit(n4));
                byArray[n4] = (byte)bidi.getRunLevel(n4);
            }
            Bidi.reorderVisually(byArray, 0, objectArray, 0, n3);
            for (n4 = 0; n4 < n3; ++n4) {
                graphics.drawString((String)objectArray[n4], n, n2);
                n += graphics.getFontMetrics().stringWidth((String)objectArray[n4]);
            }
        } else {
            graphics.drawString(string, n, n2);
        }
    }

    private static boolean characterIsLTR(char c) {
        byte by = Character.getDirectionality(c);
        return by == 0 || by == 14 || by == 15;
    }

    private static boolean characterIsRTL(char c) {
        byte by = Character.getDirectionality(c);
        return by == 1 || by == 2 || by == 16 || by == 17;
    }

    public boolean isBiDiString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            byte by = Character.getDirectionality(string.charAt(i));
            if (by != 2 && by != 6 && by != 1) continue;
            return true;
        }
        return false;
    }

    public String normalizeExpression(String string) {
        return this.normalizeExpression(string, false);
    }

    public String normalizeExpression(String string, boolean bl) {
        try {
            if (!this.isBiDiString(string)) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            if (bl) {
                stringBuffer = stringBuffer.insert(0, '\u202a');
            }
            stringBuffer = BidiUtilImpl.fullRelativePath(stringBuffer);
            if (bl) {
                stringBuffer.append(PDF);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    private static StringBuffer fullRelativePath(StringBuffer stringBuffer) throws ArrayIndexOutOfBoundsException {
        try {
            int n = stringBuffer.length();
            for (int i = 0; i < n; ++i) {
                boolean bl;
                char c;
                byte by;
                char c2 = stringBuffer.charAt(i);
                if (!(i <= 0 || c2 != ':' && c2 != '\\' && c2 != '/' && c2 != '.' && c2 != '{' && c2 != '}' && c2 != '_' && c2 != '[' && c2 != '=' && c2 != '(' && c2 != '<' && c2 != '>' && c2 != ',' || (by = Character.getDirectionality(c = stringBuffer.charAt(i - 1))) != 2 && by != 6 && by != 1)) {
                    stringBuffer = stringBuffer.insert(i, LRM);
                }
                if (i <= 0 || !Character.isWhitespace(c2) || !(bl = BidiUtilImpl.checkIfSequenceSeperator(stringBuffer, i))) continue;
                stringBuffer = stringBuffer.insert(i, LRM);
            }
            return stringBuffer;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println(arrayIndexOutOfBoundsException.toString());
            return null;
        }
    }

    private static boolean checkIfSequenceSeperator(StringBuffer stringBuffer, int n) throws ArrayIndexOutOfBoundsException {
        try {
            return n + 2 < stringBuffer.length() && stringBuffer.charAt(n + 1) == '-' && Character.isWhitespace(stringBuffer.charAt(n + 2));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println(arrayIndexOutOfBoundsException.toString());
            return false;
        }
    }

    public void registerKeyBoardManager(Component component) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(new ZeroGuh(this, component));
    }

    public ActionListener[] getButtonActionListeners(Object object) {
        return ((AbstractButton)object).getActionListeners();
    }

    private static void logicalToVisual(StringBuffer stringBuffer) {
        int n;
        if (stringBuffer == null) {
            return;
        }
        String string = stringBuffer.toString();
        if (!ZeroGbb.b().isBiDiString(string)) {
            return;
        }
        Bidi bidi = new Bidi(string, 1);
        int n2 = bidi.getRunCount();
        int[][] nArrayArray = new int[n2][];
        byte[] byArray = new byte[n2];
        Object[] objectArray = new String[n2];
        Object[] objectArray2 = new Integer[n2];
        for (n = 0; n < n2; ++n) {
            int n3 = bidi.getRunStart(n);
            int n4 = bidi.getRunLimit(n);
            nArrayArray[n] = new int[]{n3, n4};
            objectArray[n] = stringBuffer.substring(n3, n4);
            byArray[n] = (byte)bidi.getRunLevel(n);
            objectArray2[n] = new Integer(byArray[n]);
            if (byArray[n] % 2 == 0) continue;
            objectArray[n] = new StringBuffer((String)objectArray[n]).reverse().toString();
        }
        Bidi.reorderVisually(byArray, 0, objectArray, 0, n2);
        Bidi.reorderVisually(byArray, 0, (Object[])nArrayArray, 0, n2);
        Bidi.reorderVisually(byArray, 0, objectArray2, 0, n2);
        stringBuffer.setLength(0);
        stringBuffer.append('\u202d');
        int n5 = -1;
        boolean bl = true;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append((String)objectArray[n]);
        }
    }

    public String shapeString(String string, int n) {
        try {
            ZeroGui zeroGui = new ZeroGui(n);
            return zeroGui.a(string);
        }
        catch (ZeroGuj zeroGuj) {
            return string;
        }
    }

    public char unshapeString(char c, int n) {
        try {
            ZeroGui zeroGui = new ZeroGui(n);
            char[] cArray = new char[]{c};
            zeroGui.a(cArray, 0, 1);
            return cArray[0];
        }
        catch (ZeroGuj zeroGuj) {
            return c;
        }
    }

    public boolean isArabicString(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (!BidiUtilImpl.isIsolatedArabicChar(cArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean normalizeArabicString(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (!BidiUtilImpl.isIsolatedArabicChar(c)) continue;
            if (c == '\u0621') {
                stringBuffer.setCharAt(i, '\ufe80');
                continue;
            }
            if (c == '\u060c') {
                stringBuffer.setCharAt(i, ',');
                continue;
            }
            if (c == '\u06d4') {
                stringBuffer.setCharAt(i, '.');
                continue;
            }
            if (c == '\u061f') {
                stringBuffer.setCharAt(i, '?');
                continue;
            }
            System.err.println("Cannot shape the strign " + stringBuffer.toString());
            return false;
        }
        return true;
    }

    private static boolean isIsolatedArabicChar(char c) {
        return c >= '\u0600' && c <= '\u06ff';
    }

    public StringBuffer handleBidiString(StringBuffer stringBuffer, int n, boolean bl, char c, MnemonicString mnemonicString) {
        if (this.isBidiLocale()) {
            String string = ZeroGbb.b().getJavaVMVendor();
            int n2 = new Integer(this.getJavaVMVersion());
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
            if (string.indexOf("sun") >= 0 && n2 < 6 && ZeroGbb.b().isBidiLocale() && n != -1) {
                BidiUtilImpl.logicalToVisual(stringBuffer);
                if (bl) {
                    stringBuffer = new StringBuffer(this.shapeString(stringBuffer.toString(), 12));
                    boolean bl2 = BidiUtilImpl.normalizeArabicString(stringBuffer = new StringBuffer(stringBuffer.substring(1)));
                    if (bl2) {
                        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
                            if (c != this.unshapeString(stringBuffer.charAt(i), 18)) continue;
                            mnemonicString.setMnemonicChar(stringBuffer.charAt(i));
                            break;
                        }
                    } else {
                        stringBuffer = stringBuffer2;
                    }
                }
            }
        }
        return stringBuffer;
    }

    public boolean isCharBeforeBiDiChar(char[] cArray, int n, int n2, boolean bl) {
        if (bl) {
            return true;
        }
        while (n > 0) {
            byte by;
            if (n == n2) {
                return false;
            }
            if ((by = Character.getDirectionality(cArray[--n])) == 2 || by == 6 || by == 1) {
                return true;
            }
            if (by != 0) continue;
            return false;
        }
        return false;
    }
}

