/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer;

import com.zerog.ia.installer.Action;
import com.zerog.ia.installer.IAStatus;
import com.zerog.ia.installer.IAStatusLog;
import com.zerog.ia.installer.InstallPiece;
import com.zerog.ia.installer.Installable;
import com.zerog.ia.installer.events.EndEvent;
import com.zerog.util.IAResourceBundle;
import java.util.Enumeration;

public abstract class InstallablePiece
extends InstallPiece
implements Installable {
    public abstract String getVisualNameSelf();

    public String getLogDescription() {
        return ZeroGee.a(IAResourceBundle.getValue("Installer.installLog.action.description"), 26) + this.getVisualNameSelf();
    }

    public void install() throws Exception {
        boolean bl = this.evalInstallRules(null);
        if (bl) {
            Object object;
            this.processEvent(new ZeroGc5(this));
            try {
                object = this.installSelf();
                if (object != null) {
                    IAStatusLog.c().a((IAStatus)object);
                }
            }
            catch (Exception exception) {
                IAStatus iAStatus = new IAStatus(this.getLogDescription());
                Enumeration enumeration = this.getVisualChildren();
                if (enumeration != null) {
                    iAStatus.a(exception.toString(), 97, "All Install Actions Beneath this Action have not been installed.");
                    IAStatusLog.c().a(iAStatus);
                    while (enumeration.hasMoreElements()) {
                        InstallPiece installPiece = (InstallPiece)enumeration.nextElement();
                        if (!(installPiece instanceof Action) || !installPiece.evalInstallRules(null)) continue;
                        IAStatus iAStatus2 = new IAStatus(installPiece, "Install Parent '" + this.getVisualNameSelf() + "' failed!", 97);
                        IAStatusLog.c().a(iAStatus2);
                    }
                } else {
                    iAStatus.a(97);
                    IAStatusLog.c().a(iAStatus);
                }
                throw exception;
            }
            this.processEvent(new EndEvent(this));
            object = this.getVisualChildren();
            if (object != null) {
                while (object.hasMoreElements()) {
                    InstallPiece installPiece = (InstallPiece)object.nextElement();
                    if (installPiece == null || !(installPiece instanceof Installable)) continue;
                    try {
                        ((Installable)((Object)installPiece)).install();
                    }
                    catch (Exception exception) {
                        System.err.println("Action: exception while executing: " + installPiece);
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    public abstract IAStatus installSelf() throws Exception;
}

