/*
 * Decompiled with CFR 0.152.
 */
package com.fazecast.jSerialComm;

import com.fazecast.jSerialComm.PDUUSC2Format;
import com.fazecast.jSerialComm.SerialPort;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class ModemAdapter {
    private String[] destinations;
    private String message;
    private int baudRate;
    private String portName;
    String mstr2 = null;
    static Logger logger = Logger.getLogger(ModemAdapter.class);

    public ModemAdapter(String portName, int baudRate, String[] destinations, String message) {
        this.destinations = destinations;
        this.message = message;
        this.baudRate = baudRate;
        this.portName = portName;
    }

    public boolean startSendForPDU() {
        boolean result;
        block15: {
            result = false;
            SerialPort serialPort = null;
            try {
                try {
                    serialPort = SerialPort.getCommPort(this.portName);
                    if (serialPort.openPort()) {
                        serialPort.setComPortParameters(this.baudRate, 8, 1, 0);
                        serialPort.setComPortTimeouts(1, 100, 1200, true);
                        String[] stringArray = this.destinations;
                        int n = this.destinations.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String destination = stringArray[n2];
                            Thread.sleep(500L);
                            if (destination != null && !"".equals(destination)) {
                                this.sendSMSPDU(serialPort, destination, this.message);
                                result = true;
                            }
                            ++n2;
                        }
                    }
                }
                catch (Exception e) {
                    result = false;
                    if (serialPort == null) break block15;
                    try {
                        serialPort.closePort();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (serialPort != null) {
                    try {
                        serialPort.closePort();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String[] destinations = new String[]{"8613924607394"};
        ModemAdapter adapter = new ModemAdapter("COM7", 9600, destinations, "This is a test for SMSzzz 11");
        try {
            adapter.startSendForPDU();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearbuffer(InputStream input) {
        try {
            int buflen = input.available();
            while (buflen > 0) {
                input.read();
                --buflen;
            }
            Thread.sleep(5L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String excuteCMD(OutputStream output, InputStream input, String cmd) {
        String result = "";
        byte[] bytes = cmd.getBytes();
        try {
            String returnValue;
            this.clearbuffer(input);
            output.write(bytes);
            output.write(13);
            output.flush();
            logger.debug((Object)("\u53d1\u9001\u547d\u4ee4\uff1a" + cmd));
            long end = System.currentTimeMillis() + 2000L;
            StringBuilder sb = new StringBuilder();
            while (System.currentTimeMillis() < end) {
                int ch = input.read();
                if (ch <= 0) continue;
                sb.append((char)ch);
            }
            result = returnValue = sb.toString();
            logger.info((Object)("reutn value: " + returnValue));
            Thread.sleep(100L);
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
        return result;
    }

    public boolean startSendForAT() {
        boolean result = false;
        SerialPort serialPort = null;
        try {
            try {
                serialPort = SerialPort.getCommPort(this.portName);
                if (serialPort.openPort()) {
                    serialPort.setComPortParameters(this.baudRate, 8, 1, 0);
                    serialPort.setComPortTimeouts(1, 100, 0);
                    OutputStream output = serialPort.getOutputStream();
                    InputStream input = serialPort.getInputStream();
                    String[] stringArray = this.destinations;
                    int n = this.destinations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String destination = stringArray[n2];
                        String at = this.excuteCMD(output, input, "AT");
                        logger.info((Object)("AT result: " + at));
                        String cmgf = this.excuteCMD(output, input, "AT+CMGF=1");
                        logger.info((Object)("CMGF result: " + cmgf));
                        if (destination != null && !"".equals(destination)) {
                            String receiveStr = this.excuteCMD(output, input, "AT+CMGS=" + destination);
                            logger.info((Object)("CMGS result: " + receiveStr));
                            if (receiveStr.contains("ERROR") || receiveStr.contains("error")) {
                                this.excuteCMD(output, input, "AT+CMGS=\"" + destination + "\"");
                            }
                            String value = this.excuteCMD(output, input, this.message);
                            while (value.indexOf(">") != -1) {
                                this.message = this.message.substring(this.message.indexOf("\r\n") + 2);
                                value = this.excuteCMD(output, input, this.message);
                                if (this.message.indexOf("\r\n") < 0) break;
                            }
                            output.write(26);
                            if (value != null && value.length() > 0) {
                                result = true;
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                result = false;
                logger.error((Object)e.toString());
                if (serialPort.isOpen()) {
                    serialPort.closePort();
                }
            }
        }
        finally {
            if (serialPort.isOpen()) {
                serialPort.closePort();
            }
        }
        return result;
    }

    private void sendAndRead(SerialPort serialPort, byte[] bytes) {
        try {
            OutputStream output = serialPort.getOutputStream();
            InputStream input = serialPort.getInputStream();
            output.write(bytes);
            output.flush();
            long end = System.currentTimeMillis() + 3000L;
            StringBuilder sb = new StringBuilder();
            while (System.currentTimeMillis() < end) {
                int ch = input.read();
                System.out.println("----------ch:" + Integer.toHexString(ch) + "|" + ch);
                if (ch <= 0) continue;
                sb.append((char)ch);
            }
            String returnValue = sb.toString();
            System.out.println(returnValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendSMSPDU(SerialPort serialPort, String phone, String message) throws Exception {
        PDUUSC2Format pdu = new PDUUSC2Format(phone, message);
        String sContent = pdu.getString();
        int length = (sContent.length() - 2) / 2;
        String cstemp = "AT";
        cstemp = String.valueOf(cstemp) + "\r";
        this.sendAndRead(serialPort, cstemp.getBytes());
        System.out.println("------ModemAdapter---------1----");
        this.delayTime();
        this.delayTime();
        cstemp = "AT+CMGF=0";
        cstemp = String.valueOf(cstemp) + "\r";
        this.sendAndRead(serialPort, cstemp.getBytes());
        System.out.println("------ModemAdapter---------2----");
        this.delayTime();
        cstemp = "AT+CMGS=" + length;
        cstemp = String.valueOf(cstemp) + "\r";
        this.sendAndRead(serialPort, cstemp.getBytes());
        System.out.println("------ModemAdapter---------3----");
        long current = System.currentTimeMillis();
        this.delayTime();
        this.sendAndRead(serialPort, sContent.getBytes());
        System.out.println("------ModemAdapter---------4----");
        this.delayTime();
        this.delayTime();
        this.sendAndRead(serialPort, new byte[]{26});
        System.out.println("------ModemAdapter---------5----");
        this.sendAndRead(serialPort, new byte[]{26});
        System.out.println("------ModemAdapter---------6----");
    }

    private void delayTime() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

