/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelAgentForwarding;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelForwardedTCPIP;
import com.jcraft.jsch.ChannelSession;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.ChannelSubsystem;
import com.jcraft.jsch.ChannelX11;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.RequestSignal;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

public abstract class Channel
implements Runnable {
    static int index = 0;
    private static Vector pool = new Vector();
    int id;
    int recipient = -1;
    byte[] type = "foo".getBytes();
    int lwsize_max;
    int lwsize = this.lwsize_max = 0x100000;
    int lmpsize = 16384;
    int rwsize = 0;
    int rmpsize = 0;
    IO io = null;
    Thread thread = null;
    boolean eof_local = false;
    boolean eof_remote = false;
    boolean close = false;
    boolean connected = false;
    int exitstatus = -1;
    int reply = 0;
    int connectTimeout = 0;
    Session session;

    static Channel getChannel(String string) {
        if (string.equals("session")) {
            return new ChannelSession();
        }
        if (string.equals("shell")) {
            return new ChannelShell();
        }
        if (string.equals("exec")) {
            return new ChannelExec();
        }
        if (string.equals("x11")) {
            return new ChannelX11();
        }
        if (string.equals("auth-agent@openssh.com")) {
            return new ChannelAgentForwarding();
        }
        if (string.equals("direct-tcpip")) {
            return new ChannelDirectTCPIP();
        }
        if (string.equals("forwarded-tcpip")) {
            return new ChannelForwardedTCPIP();
        }
        if (string.equals("sftp")) {
            return new ChannelSftp();
        }
        if (string.equals("subsystem")) {
            return new ChannelSubsystem();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Channel getChannel(int n, Session session) {
        Vector vector = pool;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < pool.size()) {
                Channel channel = (Channel)pool.elementAt(n2);
                if (channel.id == n && channel.session == session) {
                    return channel;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void del(Channel channel) {
        Vector vector = pool;
        synchronized (vector) {
            pool.removeElement(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Channel() {
        Vector vector = pool;
        synchronized (vector) {
            this.id = index++;
            pool.addElement(this);
        }
    }

    void setRecipient(int n) {
        this.recipient = n;
    }

    int getRecipient() {
        return this.recipient;
    }

    void init() {
    }

    public void connect() throws JSchException {
        this.connect(0);
    }

    public void connect(int n) throws JSchException {
        block9: {
            if (!this.session.isConnected()) {
                throw new JSchException("session is down");
            }
            this.connectTimeout = n;
            try {
                Buffer buffer = new Buffer(100);
                Packet packet = new Packet(buffer);
                packet.reset();
                buffer.putByte((byte)90);
                buffer.putString(this.type);
                buffer.putInt(this.id);
                buffer.putInt(this.lwsize);
                buffer.putInt(this.lmpsize);
                this.session.write(packet);
                int n2 = 1000;
                long l = System.currentTimeMillis();
                long l2 = n;
                while (this.getRecipient() == -1 && this.session.isConnected() && n2 > 0) {
                    if (l2 > 0L && System.currentTimeMillis() - l > l2) {
                        n2 = 0;
                        continue;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    --n2;
                }
                if (!this.session.isConnected()) {
                    throw new JSchException("session is down");
                }
                if (n2 == 0) {
                    throw new JSchException("channel is not opened.");
                }
                this.connected = true;
                this.start();
            }
            catch (Exception exception) {
                this.connected = false;
                if (!(exception instanceof JSchException)) break block9;
                throw (JSchException)exception;
            }
        }
    }

    public void setXForwarding(boolean bl) {
    }

    public void start() throws JSchException {
    }

    public boolean isEOF() {
        return this.eof_remote;
    }

    void getData(Buffer buffer) {
        this.setRecipient(buffer.getInt());
        this.setRemoteWindowSize(buffer.getInt());
        this.setRemotePacketSize(buffer.getInt());
    }

    public void setInputStream(InputStream inputStream) {
        this.io.setInputStream(inputStream, false);
    }

    public void setInputStream(InputStream inputStream, boolean bl) {
        this.io.setInputStream(inputStream, bl);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.io.setOutputStream(outputStream, false);
    }

    public void setOutputStream(OutputStream outputStream, boolean bl) {
        this.io.setOutputStream(outputStream, bl);
    }

    public void setExtOutputStream(OutputStream outputStream) {
        this.io.setExtOutputStream(outputStream, false);
    }

    public void setExtOutputStream(OutputStream outputStream, boolean bl) {
        this.io.setExtOutputStream(outputStream, bl);
    }

    public InputStream getInputStream() throws IOException {
        MyPipedInputStream myPipedInputStream = new MyPipedInputStream(32768);
        this.io.setOutputStream(new PassiveOutputStream(myPipedInputStream), false);
        return myPipedInputStream;
    }

    public InputStream getExtInputStream() throws IOException {
        MyPipedInputStream myPipedInputStream = new MyPipedInputStream(32768);
        this.io.setExtOutputStream(new PassiveOutputStream(myPipedInputStream), false);
        return myPipedInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        final Channel channel = this;
        OutputStream outputStream = new OutputStream(){
            private int dataLen = 0;
            private Buffer buffer = null;
            private Packet packet = null;
            private boolean closed = false;
            byte[] b = new byte[1];

            private void init() {
                this.buffer = new Buffer(Channel.this.rmpsize);
                this.packet = new Packet(this.buffer);
            }

            public void write(int n) throws IOException {
                this.b[0] = (byte)n;
                this.write(this.b, 0, 1);
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                if (this.packet == null) {
                    this.init();
                }
                if (this.closed) {
                    throw new IOException("Already closed");
                }
                byte[] byArray2 = this.buffer.buffer;
                int n3 = byArray2.length;
                while (n2 > 0) {
                    int n4 = n2;
                    if (n2 > n3 - (14 + this.dataLen) - 32 - 20) {
                        n4 = n3 - (14 + this.dataLen) - 32 - 20;
                    }
                    if (n4 <= 0) {
                        this.flush();
                        continue;
                    }
                    System.arraycopy(byArray, n, byArray2, 14 + this.dataLen, n4);
                    this.dataLen += n4;
                    n += n4;
                    n2 -= n4;
                }
            }

            public void flush() throws IOException {
                if (this.closed) {
                    throw new IOException("Already closed");
                }
                if (this.dataLen == 0) {
                    return;
                }
                this.packet.reset();
                this.buffer.putByte((byte)94);
                this.buffer.putInt(Channel.this.recipient);
                this.buffer.putInt(this.dataLen);
                this.buffer.skip(this.dataLen);
                try {
                    int n = this.dataLen;
                    this.dataLen = 0;
                    Channel.this.session.write(this.packet, channel, n);
                }
                catch (Exception exception) {
                    this.close();
                    throw new IOException(exception.toString());
                }
            }

            public void close() throws IOException {
                if (this.packet == null) {
                    this.init();
                }
                if (this.closed) {
                    return;
                }
                if (this.dataLen > 0) {
                    this.flush();
                }
                channel.eof();
                this.closed = true;
            }
        };
        return outputStream;
    }

    void setLocalWindowSizeMax(int n) {
        this.lwsize_max = n;
    }

    void setLocalWindowSize(int n) {
        this.lwsize = n;
    }

    void setLocalPacketSize(int n) {
        this.lmpsize = n;
    }

    synchronized void setRemoteWindowSize(int n) {
        this.rwsize = n;
    }

    synchronized void addRemoteWindowSize(int n) {
        this.rwsize += n;
    }

    void setRemotePacketSize(int n) {
        this.rmpsize = n;
    }

    public void run() {
    }

    void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.io.put(byArray, n, n2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void write_ext(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.io.put_ext(byArray, n, n2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void eof_remote() {
        this.eof_remote = true;
        try {
            if (this.io.out != null) {
                this.io.out.close();
                this.io.out = null;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void eof() {
        if (this.close) {
            return;
        }
        if (this.eof_local) {
            return;
        }
        this.eof_local = true;
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)96);
            buffer.putInt(this.getRecipient());
            this.session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void close() {
        if (this.close) {
            return;
        }
        this.close = true;
        this.eof_remote = true;
        this.eof_local = true;
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)97);
            buffer.putInt(this.getRecipient());
            this.session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this.close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disconnect(Session session) {
        int n;
        Channel[] channelArray = null;
        int n2 = 0;
        Vector vector = pool;
        synchronized (vector) {
            channelArray = new Channel[pool.size()];
            n = 0;
            while (n < pool.size()) {
                try {
                    Channel channel = (Channel)pool.elementAt(n);
                    if (channel.session == session) {
                        channelArray[n2++] = channel;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
        }
        n = 0;
        while (n < n2) {
            channelArray[n].disconnect();
            ++n;
        }
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        this.close();
        this.eof_local = true;
        this.eof_remote = true;
        this.thread = null;
        try {
            if (this.io != null) {
                this.io.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.io = null;
        Channel.del(this);
    }

    public boolean isConnected() {
        if (this.session != null) {
            return this.session.isConnected() && this.connected;
        }
        return false;
    }

    public void sendSignal(String string) throws Exception {
        RequestSignal requestSignal = new RequestSignal();
        requestSignal.setSignal(string);
        requestSignal.request(this.session, this);
    }

    void setExitStatus(int n) {
        this.exitstatus = n;
    }

    public int getExitStatus() {
        return this.exitstatus;
    }

    void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public int getId() {
        return this.id;
    }

    class MyPipedInputStream
    extends PipedInputStream {
        MyPipedInputStream() throws IOException {
        }

        MyPipedInputStream(int n) throws IOException {
            this.buffer = new byte[n];
        }

        MyPipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
            super(pipedOutputStream);
        }

        MyPipedInputStream(PipedOutputStream pipedOutputStream, int n) throws IOException {
            super(pipedOutputStream);
            this.buffer = new byte[n];
        }
    }

    class PassiveInputStream
    extends MyPipedInputStream {
        PipedOutputStream out;

        PassiveInputStream(PipedOutputStream pipedOutputStream, int n) throws IOException {
            super(pipedOutputStream, n);
            this.out = pipedOutputStream;
        }

        PassiveInputStream(PipedOutputStream pipedOutputStream) throws IOException {
            super(pipedOutputStream);
            this.out = pipedOutputStream;
        }

        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
    }

    class PassiveOutputStream
    extends PipedOutputStream {
        PassiveOutputStream(PipedInputStream pipedInputStream) throws IOException {
            super(pipedInputStream);
        }
    }
}

