/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.CharSetUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.WordUtils;

public class StringUtils {
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static boolean isBlank(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return true;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isNotBlank(String string) {
        return !StringUtils.isBlank(string);
    }

    public static String clean(String string) {
        return string == null ? EMPTY : string.trim();
    }

    public static String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static String trimToNull(String string) {
        String string2 = StringUtils.trim(string);
        return StringUtils.isEmpty(string2) ? null : string2;
    }

    public static String trimToEmpty(String string) {
        return string == null ? EMPTY : string.trim();
    }

    public static String strip(String string) {
        return StringUtils.strip(string, null);
    }

    public static String stripToNull(String string) {
        if (string == null) {
            return null;
        }
        return (string = StringUtils.strip(string, null)).length() == 0 ? null : string;
    }

    public static String stripToEmpty(String string) {
        return string == null ? EMPTY : StringUtils.strip(string, null);
    }

    public static String strip(String string, String string2) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        string = StringUtils.stripStart(string, string2);
        return StringUtils.stripEnd(string, string2);
    }

    /*
     * Unable to fully structure code
     */
    public static String stripStart(String var0, String var1_1) {
        block4: {
            block3: {
                if (var0 == null || (var2_2 = var0.length()) == 0) {
                    return var0;
                }
                var3_3 = 0;
                if (var1_1 != null) break block3;
                while (var3_3 != var2_2 && Character.isWhitespace(var0.charAt(var3_3))) {
                    ++var3_3;
                }
                break block4;
            }
            if (var1_1.length() != 0) ** GOTO lbl13
            return var0;
lbl-1000:
            // 1 sources

            {
                ++var3_3;
lbl13:
                // 2 sources

                ** while (var3_3 != var2_2 && var1_1.indexOf((int)var0.charAt((int)var3_3)) != -1)
            }
        }
        return var0.substring(var3_3);
    }

    /*
     * Unable to fully structure code
     */
    public static String stripEnd(String var0, String var1_1) {
        block4: {
            block3: {
                if (var0 == null || (var2_2 = var0.length()) == 0) {
                    return var0;
                }
                if (var1_1 != null) break block3;
                while (var2_2 != 0 && Character.isWhitespace(var0.charAt(var2_2 - 1))) {
                    --var2_2;
                }
                break block4;
            }
            if (var1_1.length() != 0) ** GOTO lbl12
            return var0;
lbl-1000:
            // 1 sources

            {
                --var2_2;
lbl12:
                // 2 sources

                ** while (var2_2 != 0 && var1_1.indexOf((int)var0.charAt((int)(var2_2 - 1))) != -1)
            }
        }
        return var0.substring(0, var2_2);
    }

    public static String[] stripAll(String[] stringArray) {
        return StringUtils.stripAll(stringArray, null);
    }

    public static String[] stripAll(String[] stringArray, String string) {
        int n;
        if (stringArray == null || (n = stringArray.length) == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = StringUtils.strip(stringArray[n2], string);
            ++n2;
        }
        return stringArray2;
    }

    public static boolean equals(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        return string == null ? string2 == null : string.equalsIgnoreCase(string2);
    }

    public static int indexOf(String string, char c) {
        if (StringUtils.isEmpty(string)) {
            return -1;
        }
        return string.indexOf(c);
    }

    public static int indexOf(String string, char c, int n) {
        if (StringUtils.isEmpty(string)) {
            return -1;
        }
        return string.indexOf(c, n);
    }

    public static int indexOf(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        return string.indexOf(string2);
    }

    public static int ordinalIndexOf(String string, String string2, int n) {
        if (string == null || string2 == null || n <= 0) {
            return -1;
        }
        if (string2.length() == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = -1;
        do {
            if ((n3 = string.indexOf(string2, n3 + 1)) >= 0) continue;
            return n3;
        } while (++n2 < n);
        return n3;
    }

    public static int indexOf(String string, String string2, int n) {
        if (string == null || string2 == null) {
            return -1;
        }
        if (string2.length() == 0 && n >= string.length()) {
            return string.length();
        }
        return string.indexOf(string2, n);
    }

    public static int lastIndexOf(String string, char c) {
        if (StringUtils.isEmpty(string)) {
            return -1;
        }
        return string.lastIndexOf(c);
    }

    public static int lastIndexOf(String string, char c, int n) {
        if (StringUtils.isEmpty(string)) {
            return -1;
        }
        return string.lastIndexOf(c, n);
    }

    public static int lastIndexOf(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        return string.lastIndexOf(string2);
    }

    public static int lastIndexOf(String string, String string2, int n) {
        if (string == null || string2 == null) {
            return -1;
        }
        return string.lastIndexOf(string2, n);
    }

    public static boolean contains(String string, char c) {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        return string.indexOf(c) >= 0;
    }

    public static boolean contains(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return string.indexOf(string2) >= 0;
    }

    public static boolean containsIgnoreCase(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return StringUtils.contains(string.toUpperCase(), string2.toUpperCase());
    }

    public static int indexOfAny(String string, char[] cArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(cArray)) {
            return -1;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            int n2 = 0;
            while (n2 < cArray.length) {
                if (cArray[n2] == c) {
                    return n;
                }
                ++n2;
            }
            ++n;
        }
        return -1;
    }

    public static int indexOfAny(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return -1;
        }
        return StringUtils.indexOfAny(string, string2.toCharArray());
    }

    public static int indexOfAnyBut(String string, char[] cArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(cArray)) {
            return -1;
        }
        int n = 0;
        while (n < string.length()) {
            block4: {
                char c = string.charAt(n);
                int n2 = 0;
                while (n2 < cArray.length) {
                    if (cArray[n2] != c) {
                        ++n2;
                        continue;
                    }
                    break block4;
                }
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int indexOfAnyBut(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return -1;
        }
        int n = 0;
        while (n < string.length()) {
            if (string2.indexOf(string.charAt(n)) < 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static boolean containsOnly(String string, char[] cArray) {
        if (cArray == null || string == null) {
            return false;
        }
        if (string.length() == 0) {
            return true;
        }
        if (cArray.length == 0) {
            return false;
        }
        return StringUtils.indexOfAnyBut(string, cArray) == -1;
    }

    public static boolean containsOnly(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return StringUtils.containsOnly(string, string2.toCharArray());
    }

    public static boolean containsNone(String string, char[] cArray) {
        if (string == null || cArray == null) {
            return true;
        }
        int n = string.length();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            int n4 = 0;
            while (n4 < n2) {
                if (cArray[n4] == c) {
                    return false;
                }
                ++n4;
            }
            ++n3;
        }
        return true;
    }

    public static boolean containsNone(String string, String string2) {
        if (string == null || string2 == null) {
            return true;
        }
        return StringUtils.containsNone(string, string2.toCharArray());
    }

    public static int indexOfAny(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return -1;
        }
        int n = stringArray.length;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            String string2 = stringArray[n4];
            if (string2 != null && (n3 = string.indexOf(string2)) != -1 && n3 < n2) {
                n2 = n3;
            }
            ++n4;
        }
        return n2 == Integer.MAX_VALUE ? -1 : n2;
    }

    public static int lastIndexOfAny(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return -1;
        }
        int n = stringArray.length;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            String string2 = stringArray[n4];
            if (string2 != null && (n3 = string.lastIndexOf(string2)) > n2) {
                n2 = n3;
            }
            ++n4;
        }
        return n2;
    }

    public static String substring(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n < 0) {
            n = string.length() + n;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > string.length()) {
            return EMPTY;
        }
        return string.substring(n);
    }

    public static String substring(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = string.length() + n2;
        }
        if (n < 0) {
            n = string.length() + n;
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n > n2) {
            return EMPTY;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return string.substring(n, n2);
    }

    public static String left(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n < 0) {
            return EMPTY;
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String right(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n < 0) {
            return EMPTY;
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(string.length() - n);
    }

    public static String mid(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 0 || n > string.length()) {
            return EMPTY;
        }
        if (n < 0) {
            n = 0;
        }
        if (string.length() <= n + n2) {
            return string.substring(n);
        }
        return string.substring(n, n + n2);
    }

    public static String substringBefore(String string, String string2) {
        if (StringUtils.isEmpty(string) || string2 == null) {
            return string;
        }
        if (string2.length() == 0) {
            return EMPTY;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String substringAfter(String string, String string2) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (string2 == null) {
            return EMPTY;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return EMPTY;
        }
        return string.substring(n + string2.length());
    }

    public static String substringBeforeLast(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        int n = string.lastIndexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String substringAfterLast(String string, String string2) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (StringUtils.isEmpty(string2)) {
            return EMPTY;
        }
        int n = string.lastIndexOf(string2);
        if (n == -1 || n == string.length() - string2.length()) {
            return EMPTY;
        }
        return string.substring(n + string2.length());
    }

    public static String substringBetween(String string, String string2) {
        return StringUtils.substringBetween(string, string2, string2);
    }

    public static String substringBetween(String string, String string2, String string3) {
        int n;
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        int n2 = string.indexOf(string2);
        if (n2 != -1 && (n = string.indexOf(string3, n2 + string2.length())) != -1) {
            return string.substring(n2 + string2.length(), n);
        }
        return null;
    }

    public static String getNestedString(String string, String string2) {
        return StringUtils.substringBetween(string, string2, string2);
    }

    public static String getNestedString(String string, String string2, String string3) {
        return StringUtils.substringBetween(string, string2, string3);
    }

    public static String[] split(String string) {
        return StringUtils.split(string, null, -1);
    }

    public static String[] split(String string, char c) {
        return StringUtils.splitWorker(string, c, false);
    }

    public static String[] split(String string, String string2) {
        return StringUtils.splitWorker(string, string2, -1, false);
    }

    public static String[] split(String string, String string2, int n) {
        return StringUtils.splitWorker(string, string2, n, false);
    }

    public static String[] splitByWholeSeparator(String string, String string2) {
        return StringUtils.splitByWholeSeparator(string, string2, -1);
    }

    public static String[] splitByWholeSeparator(String string, String string2, int n) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (string2 == null || EMPTY.equals(string2)) {
            return StringUtils.split(string, null, n);
        }
        int n3 = string2.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            n6 = string.indexOf(string2, n5);
            if (n6 > -1) {
                if (n6 > n5) {
                    if (++n4 == n) {
                        n6 = n2;
                        arrayList.add(string.substring(n5));
                        continue;
                    }
                    arrayList.add(string.substring(n5, n6));
                    n5 = n6 + n3;
                    continue;
                }
                n5 = n6 + n3;
                continue;
            }
            arrayList.add(string.substring(n5));
            n6 = n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] splitPreserveAllTokens(String string) {
        return StringUtils.splitWorker(string, null, -1, true);
    }

    public static String[] splitPreserveAllTokens(String string, char c) {
        return StringUtils.splitWorker(string, c, true);
    }

    private static String[] splitWorker(String string, char c, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n2 < n) {
            if (string.charAt(n2) == c) {
                if (bl2 || bl) {
                    arrayList.add(string.substring(n3, n2));
                    bl2 = false;
                    bl3 = true;
                }
                n3 = ++n2;
                continue;
            }
            bl3 = false;
            bl2 = true;
            ++n2;
        }
        if (bl2 || bl && bl3) {
            arrayList.add(string.substring(n3, n2));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] splitPreserveAllTokens(String string, String string2) {
        return StringUtils.splitWorker(string, string2, -1, true);
    }

    public static String[] splitPreserveAllTokens(String string, String string2, int n) {
        return StringUtils.splitWorker(string, string2, n, true);
    }

    /*
     * Unable to fully structure code
     */
    private static String[] splitWorker(String var0, String var1_1, int var2_2, boolean var3_3) {
        block16: {
            block15: {
                if (var0 == null) {
                    return null;
                }
                var4_4 = var0.length();
                if (var4_4 == 0) {
                    return ArrayUtils.EMPTY_STRING_ARRAY;
                }
                var5_5 = new ArrayList<String>();
                var6_6 = 1;
                var7_7 = 0;
                var8_8 = 0;
                var9_9 = false;
                var10_10 = false;
                if (var1_1 != null) break block15;
                while (var7_7 < var4_4) {
                    if (Character.isWhitespace(var0.charAt(var7_7))) {
                        if (var9_9 || var3_3) {
                            var10_10 = true;
                            if (var6_6++ == var2_2) {
                                var7_7 = var4_4;
                                var10_10 = false;
                            }
                            var5_5.add(var0.substring(var8_8, var7_7));
                            var9_9 = false;
                        }
                        var8_8 = ++var7_7;
                        continue;
                    }
                    var10_10 = false;
                    var9_9 = true;
                    ++var7_7;
                }
                break block16;
            }
            if (var1_1.length() != 1) ** GOTO lbl64
            var11_11 = var1_1.charAt(0);
            while (var7_7 < var4_4) {
                if (var0.charAt(var7_7) == var11_11) {
                    if (var9_9 || var3_3) {
                        var10_10 = true;
                        if (var6_6++ == var2_2) {
                            var7_7 = var4_4;
                            var10_10 = false;
                        }
                        var5_5.add(var0.substring(var8_8, var7_7));
                        var9_9 = false;
                    }
                    var8_8 = ++var7_7;
                    continue;
                }
                var10_10 = false;
                var9_9 = true;
                ++var7_7;
            }
            break block16;
lbl-1000:
            // 1 sources

            {
                if (var1_1.indexOf(var0.charAt(var7_7)) >= 0) {
                    if (var9_9 || var3_3) {
                        var10_10 = true;
                        if (var6_6++ == var2_2) {
                            var7_7 = var4_4;
                            var10_10 = false;
                        }
                        var5_5.add(var0.substring(var8_8, var7_7));
                        var9_9 = false;
                    }
                    var8_8 = ++var7_7;
                    continue;
                }
                var10_10 = false;
                var9_9 = true;
                ++var7_7;
lbl64:
                // 3 sources

                ** while (var7_7 < var4_4)
            }
        }
        if (var9_9 || var3_3 && var10_10) {
            var5_5.add(var0.substring(var8_8, var7_7));
        }
        return var5_5.toArray(new String[var5_5.size()]);
    }

    public static String concatenate(Object[] objectArray) {
        return StringUtils.join(objectArray, null);
    }

    public static String join(Object[] objectArray) {
        return StringUtils.join(objectArray, null);
    }

    public static String join(Object[] objectArray, char c) {
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length;
        int n2 = n == 0 ? 0 : ((objectArray[0] == null ? 16 : objectArray[0].toString().length()) + 1) * n;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n) {
            if (n3 > 0) {
                stringBuffer.append(c);
            }
            if (objectArray[n3] != null) {
                stringBuffer.append(objectArray[n3]);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String join(Object[] objectArray, String string) {
        int n;
        if (objectArray == null) {
            return null;
        }
        if (string == null) {
            string = EMPTY;
        }
        int n2 = (n = objectArray.length) == 0 ? 0 : n * ((objectArray[0] == null ? 16 : objectArray[0].toString().length()) + string.length());
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n) {
            if (n3 > 0) {
                stringBuffer.append(string);
            }
            if (objectArray[n3] != null) {
                stringBuffer.append(objectArray[n3]);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String join(Iterator iterator, char c) {
        if (iterator == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e != null) {
                stringBuffer.append(e);
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String join(Iterator iterator, String string) {
        if (iterator == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e != null) {
                stringBuffer.append(e);
            }
            if (string == null || !iterator.hasNext()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String deleteSpaces(String string) {
        if (string == null) {
            return null;
        }
        return CharSetUtils.delete(string, " \t\r\n\b");
    }

    public static String deleteWhitespace(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (!Character.isWhitespace(string.charAt(n3))) {
                cArray[n2++] = string.charAt(n3);
            }
            ++n3;
        }
        if (n2 == n) {
            return string;
        }
        return new String(cArray, 0, n2);
    }

    public static String removeStart(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static String removeEnd(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String remove(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        return StringUtils.replace(string, string2, EMPTY, -1);
    }

    public static String remove(String string, char c) {
        if (StringUtils.isEmpty(string) || string.indexOf(c) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] != c) {
                cArray[n++] = cArray[n2];
            }
            ++n2;
        }
        return new String(cArray, 0, n);
    }

    public static String replaceOnce(String string, String string2, String string3) {
        return StringUtils.replace(string, string2, string3, 1);
    }

    public static String replace(String string, String string2, String string3) {
        return StringUtils.replace(string, string2, string3, -1);
    }

    public static String replace(String string, String string2, String string3, int n) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2) || string3 == null || n == 0) {
            return string;
        }
        int n2 = 0;
        int n3 = string.indexOf(string2, n2);
        if (n3 == -1) {
            return string;
        }
        int n4 = string2.length();
        int n5 = string3.length() - n4;
        int n6 = n5 = n5 < 0 ? 0 : n5;
        StringBuffer stringBuffer = new StringBuffer(string.length() + (n5 *= n < 0 ? 16 : (n > 64 ? 64 : n)));
        while (n3 != -1) {
            stringBuffer.append(string.substring(n2, n3)).append(string3);
            n2 = n3 + n4;
            if (--n == 0) break;
            n3 = string.indexOf(string2, n2);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String replaceChars(String string, char c, char c2) {
        if (string == null) {
            return null;
        }
        return string.replace(c, c2);
    }

    public static String replaceChars(String string, String string2, String string3) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (string3 == null) {
            string3 = EMPTY;
        }
        boolean bl = false;
        int n = string3.length();
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            int n4 = string2.indexOf(c);
            if (n4 >= 0) {
                bl = true;
                if (n4 < n) {
                    stringBuffer.append(string3.charAt(n4));
                }
            } else {
                stringBuffer.append(c);
            }
            ++n3;
        }
        if (bl) {
            return stringBuffer.toString();
        }
        return string;
    }

    public static String overlayString(String string, String string2, int n, int n2) {
        return new StringBuffer(n + string2.length() + string.length() - n2 + 1).append(string.substring(0, n)).append(string2).append(string.substring(n2)).toString();
    }

    public static String overlay(String string, String string2, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = EMPTY;
        }
        int n3 = string.length();
        if (n < 0) {
            n = 0;
        }
        if (n > n3) {
            n = n3;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (n > n2) {
            int n4 = n;
            n = n2;
            n2 = n4;
        }
        return new StringBuffer(n3 + n - n2 + string2.length() + 1).append(string.substring(0, n)).append(string2).append(string.substring(n2)).toString();
    }

    public static String chomp(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (string.length() == 1) {
            char c = string.charAt(0);
            if (c == '\r' || c == '\n') {
                return EMPTY;
            }
            return string;
        }
        int n = string.length() - 1;
        char c = string.charAt(n);
        if (c == '\n') {
            if (string.charAt(n - 1) == '\r') {
                --n;
            }
        } else if (c != '\r') {
            ++n;
        }
        return string.substring(0, n);
    }

    public static String chomp(String string, String string2) {
        if (StringUtils.isEmpty(string) || string2 == null) {
            return string;
        }
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String chompLast(String string) {
        return StringUtils.chompLast(string, "\n");
    }

    public static String chompLast(String string, String string2) {
        if (string.length() == 0) {
            return string;
        }
        String string3 = string.substring(string.length() - string2.length());
        if (string2.equals(string3)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String getChomp(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n == string.length() - string2.length()) {
            return string2;
        }
        if (n != -1) {
            return string.substring(n);
        }
        return EMPTY;
    }

    public static String prechomp(String string, String string2) {
        int n = string.indexOf(string2);
        if (n != -1) {
            return string.substring(n + string2.length());
        }
        return string;
    }

    public static String getPrechomp(String string, String string2) {
        int n = string.indexOf(string2);
        if (n != -1) {
            return string.substring(0, n + string2.length());
        }
        return EMPTY;
    }

    public static String chop(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n < 2) {
            return EMPTY;
        }
        int n2 = n - 1;
        String string2 = string.substring(0, n2);
        char c = string.charAt(n2);
        if (c == '\n' && string2.charAt(n2 - 1) == '\r') {
            return string2.substring(0, n2 - 1);
        }
        return string2;
    }

    public static String chopNewline(String string) {
        int n = string.length() - 1;
        if (n <= 0) {
            return EMPTY;
        }
        char c = string.charAt(n);
        if (c == '\n') {
            if (string.charAt(n - 1) == '\r') {
                --n;
            }
        } else {
            ++n;
        }
        return string.substring(0, n);
    }

    public static String escape(String string) {
        return StringEscapeUtils.escapeJava(string);
    }

    public static String repeat(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n <= 0) {
            return EMPTY;
        }
        int n2 = string.length();
        if (n == 1 || n2 == 0) {
            return string;
        }
        if (n2 == 1 && n <= 8192) {
            return StringUtils.padding(n, string.charAt(0));
        }
        int n3 = n2 * n;
        switch (n2) {
            case 1: {
                char c = string.charAt(0);
                char[] cArray = new char[n3];
                int n4 = n - 1;
                while (n4 >= 0) {
                    cArray[n4] = c;
                    --n4;
                }
                return new String(cArray);
            }
            case 2: {
                char c = string.charAt(0);
                char c2 = string.charAt(1);
                char[] cArray = new char[n3];
                int n5 = n * 2 - 2;
                while (n5 >= 0) {
                    cArray[n5] = c;
                    cArray[n5 + 1] = c2;
                    --n5;
                    --n5;
                }
                return new String(cArray);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        int n6 = 0;
        while (n6 < n) {
            stringBuffer.append(string);
            ++n6;
        }
        return stringBuffer.toString();
    }

    private static String padding(int n, char c) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + n);
        }
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < cArray.length) {
            cArray[n2] = c;
            ++n2;
        }
        return new String(cArray);
    }

    public static String rightPad(String string, int n) {
        return StringUtils.rightPad(string, n, ' ');
    }

    public static String rightPad(String string, int n, char c) {
        if (string == null) {
            return null;
        }
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        if (n2 > 8192) {
            return StringUtils.rightPad(string, n, String.valueOf(c));
        }
        return string.concat(StringUtils.padding(n2, c));
    }

    public static String rightPad(String string, int n, String string2) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = " ";
        }
        int n2 = string2.length();
        int n3 = string.length();
        int n4 = n - n3;
        if (n4 <= 0) {
            return string;
        }
        if (n2 == 1 && n4 <= 8192) {
            return StringUtils.rightPad(string, n, string2.charAt(0));
        }
        if (n4 == n2) {
            return string.concat(string2);
        }
        if (n4 < n2) {
            return string.concat(string2.substring(0, n4));
        }
        char[] cArray = new char[n4];
        char[] cArray2 = string2.toCharArray();
        int n5 = 0;
        while (n5 < n4) {
            cArray[n5] = cArray2[n5 % n2];
            ++n5;
        }
        return string.concat(new String(cArray));
    }

    public static String leftPad(String string, int n) {
        return StringUtils.leftPad(string, n, ' ');
    }

    public static String leftPad(String string, int n, char c) {
        if (string == null) {
            return null;
        }
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        if (n2 > 8192) {
            return StringUtils.leftPad(string, n, String.valueOf(c));
        }
        return StringUtils.padding(n2, c).concat(string);
    }

    public static String leftPad(String string, int n, String string2) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = " ";
        }
        int n2 = string2.length();
        int n3 = string.length();
        int n4 = n - n3;
        if (n4 <= 0) {
            return string;
        }
        if (n2 == 1 && n4 <= 8192) {
            return StringUtils.leftPad(string, n, string2.charAt(0));
        }
        if (n4 == n2) {
            return string2.concat(string);
        }
        if (n4 < n2) {
            return string2.substring(0, n4).concat(string);
        }
        char[] cArray = new char[n4];
        char[] cArray2 = string2.toCharArray();
        int n5 = 0;
        while (n5 < n4) {
            cArray[n5] = cArray2[n5 % n2];
            ++n5;
        }
        return new String(cArray).concat(string);
    }

    public static String center(String string, int n) {
        return StringUtils.center(string, n, ' ');
    }

    public static String center(String string, int n, char c) {
        if (string == null || n <= 0) {
            return string;
        }
        int n2 = string.length();
        int n3 = n - n2;
        if (n3 <= 0) {
            return string;
        }
        string = StringUtils.leftPad(string, n2 + n3 / 2, c);
        string = StringUtils.rightPad(string, n, c);
        return string;
    }

    public static String center(String string, int n, String string2) {
        int n2;
        int n3;
        if (string == null || n <= 0) {
            return string;
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = " ";
        }
        if ((n3 = n - (n2 = string.length())) <= 0) {
            return string;
        }
        string = StringUtils.leftPad(string, n2 + n3 / 2, string2);
        string = StringUtils.rightPad(string, n, string2);
        return string;
    }

    public static String upperCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase();
    }

    public static String lowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static String capitalize(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return string;
        }
        return new StringBuffer(n).append(Character.toTitleCase(string.charAt(0))).append(string.substring(1)).toString();
    }

    public static String capitalise(String string) {
        return StringUtils.capitalize(string);
    }

    public static String uncapitalize(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return string;
        }
        return new StringBuffer(n).append(Character.toLowerCase(string.charAt(0))).append(string.substring(1)).toString();
    }

    public static String uncapitalise(String string) {
        return StringUtils.uncapitalize(string);
    }

    public static String swapCase(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        char c = '\u0000';
        int n2 = 0;
        while (n2 < n) {
            c = string.charAt(n2);
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            } else if (Character.isTitleCase(c)) {
                c = Character.toLowerCase(c);
            } else if (Character.isLowerCase(c)) {
                c = Character.toUpperCase(c);
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String capitaliseAllWords(String string) {
        return WordUtils.capitalize(string);
    }

    public static int countMatches(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n2)) != -1) {
            ++n;
            n2 += string2.length();
        }
        return n;
    }

    public static boolean isAlpha(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isLetter(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isAlphaSpace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isLetter(string.charAt(n2)) && string.charAt(n2) != ' ') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isAlphanumeric(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isLetterOrDigit(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isLetterOrDigit(string.charAt(n2)) && string.charAt(n2) != ' ') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isAsciiPrintable(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!CharUtils.isAsciiPrintable(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isDigit(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isNumericSpace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isDigit(string.charAt(n2)) && string.charAt(n2) != ' ') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isWhitespace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String defaultString(String string) {
        return string == null ? EMPTY : string;
    }

    public static String defaultString(String string, String string2) {
        return string == null ? string2 : string;
    }

    public static String defaultIfEmpty(String string, String string2) {
        return StringUtils.isEmpty(string) ? string2 : string;
    }

    public static String reverse(String string) {
        if (string == null) {
            return null;
        }
        return new StringBuffer(string).reverse().toString();
    }

    public static String reverseDelimited(String string, char c) {
        if (string == null) {
            return null;
        }
        Object[] objectArray = StringUtils.split(string, c);
        ArrayUtils.reverse(objectArray);
        return StringUtils.join(objectArray, c);
    }

    public static String reverseDelimitedString(String string, String string2) {
        if (string == null) {
            return null;
        }
        Object[] objectArray = StringUtils.split(string, string2);
        ArrayUtils.reverse(objectArray);
        if (string2 == null) {
            return StringUtils.join(objectArray, ' ');
        }
        return StringUtils.join(objectArray, string2);
    }

    public static String abbreviate(String string, int n) {
        return StringUtils.abbreviate(string, 0, n);
    }

    public static String abbreviate(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (string.length() <= n2) {
            return string;
        }
        if (n > string.length()) {
            n = string.length();
        }
        if (string.length() - n < n2 - 3) {
            n = string.length() - (n2 - 3);
        }
        if (n <= 4) {
            return string.substring(0, n2 - 3) + "...";
        }
        if (n2 < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (n + (n2 - 3) < string.length()) {
            return "..." + StringUtils.abbreviate(string.substring(n), n2 - 3);
        }
        return "..." + string.substring(string.length() - (n2 - 3));
    }

    public static String difference(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n = StringUtils.indexOfDifference(string, string2);
        if (n == -1) {
            return EMPTY;
        }
        return string2.substring(n);
    }

    public static int indexOfDifference(String string, String string2) {
        if (string == string2) {
            return -1;
        }
        if (string == null || string2 == null) {
            return 0;
        }
        int n = 0;
        while (n < string.length() && n < string2.length()) {
            if (string.charAt(n) != string2.charAt(n)) break;
            ++n;
        }
        if (n < string2.length() || n < string.length()) {
            return n;
        }
        return -1;
    }

    public static int getLevenshteinDistance(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = string.length();
        int n2 = string2.length();
        if (n == 0) {
            return n2;
        }
        if (n2 == 0) {
            return n;
        }
        int[] nArray = new int[n + 1];
        int[] nArray2 = new int[n + 1];
        int n3 = 0;
        while (n3 <= n) {
            nArray[n3] = n3;
            ++n3;
        }
        int n4 = 1;
        while (n4 <= n2) {
            char c = string2.charAt(n4 - 1);
            nArray2[0] = n4;
            n3 = 1;
            while (n3 <= n) {
                int n5 = string.charAt(n3 - 1) == c ? 0 : 1;
                nArray2[n3] = Math.min(Math.min(nArray2[n3 - 1] + 1, nArray[n3] + 1), nArray[n3 - 1] + n5);
                ++n3;
            }
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
            ++n4;
        }
        return nArray[n];
    }
}

