/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.CharSet;
import org.apache.commons.lang.StringUtils;

public class CharSetUtils {
    public static CharSet evaluateSet(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        return new CharSet(stringArray);
    }

    public static String squeeze(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        String[] stringArray = new String[]{string2};
        return CharSetUtils.squeeze(string, stringArray);
    }

    public static String squeeze(String string, String[] stringArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(stringArray)) {
            return string;
        }
        CharSet charSet = CharSetUtils.evaluateSet(stringArray);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 32;
        int n3 = 32;
        int n4 = 0;
        while (n4 < n) {
            n3 = cArray[n4];
            if (!charSet.contains((char)n3) || n3 != n2 || n4 == 0) {
                stringBuffer.append((char)n3);
                n2 = n3;
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static int count(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return 0;
        }
        String[] stringArray = new String[]{string2};
        return CharSetUtils.count(string, stringArray);
    }

    public static int count(String string, String[] stringArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(stringArray)) {
            return 0;
        }
        CharSet charSet = CharSetUtils.evaluateSet(stringArray);
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (charSet.contains(cArray[n3])) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public static String keep(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0 || StringUtils.isEmpty(string2)) {
            return "";
        }
        String[] stringArray = new String[]{string2};
        return CharSetUtils.keep(string, stringArray);
    }

    public static String keep(String string, String[] stringArray) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0 || ArrayUtils.isEmpty(stringArray)) {
            return "";
        }
        return CharSetUtils.modify(string, stringArray, true);
    }

    public static String delete(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        String[] stringArray = new String[]{string2};
        return CharSetUtils.delete(string, stringArray);
    }

    public static String delete(String string, String[] stringArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(stringArray)) {
            return string;
        }
        return CharSetUtils.modify(string, stringArray, false);
    }

    private static String modify(String string, String[] stringArray, boolean bl) {
        CharSet charSet = CharSetUtils.evaluateSet(stringArray);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (charSet.contains(cArray[n2]) == bl) {
                stringBuffer.append(cArray[n2]);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String translate(String string, String string2, String string3) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        char[] cArray2 = string3.toCharArray();
        int n = cArray.length;
        int n2 = string3.length() - 1;
        int n3 = 0;
        while (n3 < n) {
            int n4 = string2.indexOf(cArray[n3]);
            if (n4 != -1) {
                if (n4 > n2) {
                    n4 = n2;
                }
                stringBuffer.append(cArray2[n4]);
            } else {
                stringBuffer.append(cArray[n3]);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }
}

