/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPool {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPool.class);
    private LinkedBlockingQueue<Runnable> taskPool;
    private List<PoolThread> threadPool = new ArrayList<PoolThread>();
    private int size;
    private boolean running;

    public ThreadPool(int size) {
        this.size = size;
        this.taskPool = new LinkedBlockingQueue();
    }

    public synchronized void execute(Runnable task) {
        if (this.running) {
            try {
                this.taskPool.put(task);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void initPool(String name) {
        this.running = true;
        int i = this.size;
        while (--i >= 0) {
            PoolThread thread = new PoolThread();
            this.threadPool.add(thread);
            thread.setName(String.format("%s Handler", name));
            thread.start();
        }
    }

    public void close() {
        if (this.running) {
            this.taskPool.clear();
            this.running = false;
            for (PoolThread thread : this.threadPool) {
                thread.interrupt();
            }
        }
    }

    private class PoolThread
    extends Thread {
        private PoolThread() {
        }

        @Override
        public void run() {
            logger.debug("Running PoolThread");
            do {
                try {
                    logger.debug("{}", (Object)this);
                    ((Runnable)ThreadPool.this.taskPool.take()).run();
                }
                catch (Exception ex) {
                    if (!ThreadPool.this.running) continue;
                    logger.error("Problem starting receiver thread", (Throwable)ex);
                }
            } while (ThreadPool.this.running);
        }
    }
}

