/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.slave;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import net.wimpi.modbus.ModbusException;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.net.ModbusSerialListener;
import net.wimpi.modbus.net.ModbusTCPListener;
import net.wimpi.modbus.net.ModbusUDPListener;
import net.wimpi.modbus.procimg.ProcessImage;
import net.wimpi.modbus.slave.ModbusSlaveFactory;
import net.wimpi.modbus.slave.ModbusSlaveType;
import net.wimpi.modbus.util.ModbusUtil;
import net.wimpi.modbus.util.SerialParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusSlave {
    private static final Logger logger = LoggerFactory.getLogger(ModbusSlave.class);
    private ModbusSlaveType type;
    private int port;
    private SerialParameters serialParams;
    private AbstractModbusListener listener;
    private boolean isRunning;
    private Thread listenerThread;
    private Map<Integer, ProcessImage> processImages = new HashMap<Integer, ProcessImage>();

    protected ModbusSlave(int port, int poolSize, boolean useRtuOverTcp) throws ModbusException {
        this(ModbusSlaveType.TCP, null, port, poolSize, null, useRtuOverTcp);
    }

    protected ModbusSlave(InetAddress address, int port, int poolSize, boolean useRtuOverTcp) throws ModbusException {
        this(ModbusSlaveType.TCP, address, port, poolSize, null, useRtuOverTcp);
    }

    protected ModbusSlave(int port, boolean useRtuOverTcp) throws ModbusException {
        this(ModbusSlaveType.UDP, null, port, 0, null, useRtuOverTcp);
    }

    protected ModbusSlave(InetAddress address, int port, boolean useRtuOverTcp) throws ModbusException {
        this(ModbusSlaveType.UDP, address, port, 0, null, useRtuOverTcp);
    }

    protected ModbusSlave(SerialParameters serialParams) throws ModbusException {
        this(ModbusSlaveType.SERIAL, null, 0, 0, serialParams, false);
    }

    private ModbusSlave(ModbusSlaveType type, InetAddress address, int port, int poolSize, SerialParameters serialParams, boolean useRtuOverTcp) throws ModbusException {
        this.type = type == null ? ModbusSlaveType.TCP : type;
        this.port = port;
        this.serialParams = serialParams;
        logger.debug("Creating {} listener", (Object)this.type);
        this.listener = this.type.is(ModbusSlaveType.UDP) ? new ModbusUDPListener() : (this.type.is(ModbusSlaveType.TCP) ? new ModbusTCPListener(poolSize, useRtuOverTcp) : new ModbusSerialListener(serialParams));
        this.listener.setListening(true);
        this.listener.setAddress(address);
        this.listener.setPort(port);
        this.listener.setTimeout(0);
    }

    public ModbusSlaveType getType() {
        return this.type;
    }

    public int getPort() {
        return this.port;
    }

    public ProcessImage getProcessImage(int unitId) {
        return this.processImages.get(unitId);
    }

    public ProcessImage removeProcessImage(int unitId) {
        return this.processImages.remove(unitId);
    }

    public ProcessImage addProcessImage(int unitId, ProcessImage processImage) {
        return this.processImages.put(unitId, processImage);
    }

    public SerialParameters getSerialParams() {
        return this.serialParams;
    }

    public void open() throws ModbusException {
        if (!this.isRunning) {
            try {
                this.listenerThread = new Thread(this.listener);
                this.listenerThread.start();
                this.isRunning = true;
            }
            catch (Exception x) {
                this.closeListener();
                throw new ModbusException(x.getMessage());
            }
        }
    }

    public void close() {
        ModbusSlaveFactory.close(this);
    }

    public String getError() {
        return this.listener != null ? this.listener.getError() : null;
    }

    protected AbstractModbusListener getListener() {
        return this.listener;
    }

    void closeListener() {
        if (this.listener != null && this.listener.isListening()) {
            this.listener.stop();
            int count = 0;
            while (this.listenerThread != null && this.listenerThread.isAlive() && count < 50) {
                ModbusUtil.sleep(100L);
                ++count;
            }
            if (this.listenerThread != null && this.listenerThread.isAlive()) {
                this.listenerThread.stop();
            }
            this.listenerThread = null;
        }
        this.isRunning = false;
    }

    public String getThreadName() {
        return this.listener == null ? null : this.listener.getThreadName();
    }

    public void setThreadName(String threadName) {
        if (this.listener != null) {
            this.listener.setThreadName(threadName);
        }
    }
}

