/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.procimg;

import java.util.Vector;
import net.wimpi.modbus.procimg.DigitalIn;
import net.wimpi.modbus.procimg.DigitalOut;
import net.wimpi.modbus.procimg.FIFO;
import net.wimpi.modbus.procimg.File;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.InputRegister;
import net.wimpi.modbus.procimg.ProcessImageImplementation;
import net.wimpi.modbus.procimg.Register;

public class SimpleProcessImage
implements ProcessImageImplementation {
    protected final Vector<DigitalIn> digitalIns = new Vector();
    protected final Vector<DigitalOut> digitalOuts = new Vector();
    protected final Vector<InputRegister> inputRegisters = new Vector();
    protected final Vector<Register> registers = new Vector();
    protected final Vector<File> files = new Vector();
    protected final Vector<FIFO> fifos = new Vector();
    protected boolean locked = false;
    protected int unitID = 0;

    public SimpleProcessImage() {
    }

    public SimpleProcessImage(int unit) {
        this.unitID = unit;
    }

    public synchronized boolean isLocked() {
        return this.locked;
    }

    public synchronized boolean setLocked(boolean locked) {
        if (this.locked && locked) {
            return false;
        }
        this.locked = locked;
        return true;
    }

    public int getUnitID() {
        return this.unitID;
    }

    @Override
    public DigitalOut[] getDigitalOutRange(int ref, int count) {
        if (ref < 0 || ref + count > this.digitalOuts.size()) {
            throw new IllegalAddressException();
        }
        DigitalOut[] douts = new DigitalOut[count];
        int i = 0;
        while (i < douts.length) {
            douts[i] = this.getDigitalOut(ref + i);
            ++i;
        }
        return douts;
    }

    @Override
    public DigitalOut getDigitalOut(int ref) throws IllegalAddressException {
        try {
            DigitalOut result = this.digitalOuts.elementAt(ref);
            if (result == null) {
                throw new IllegalAddressException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public int getDigitalOutCount() {
        return this.digitalOuts.size();
    }

    @Override
    public DigitalIn[] getDigitalInRange(int ref, int count) {
        if (ref < 0 || ref + count > this.digitalIns.size()) {
            throw new IllegalAddressException();
        }
        DigitalIn[] dins = new DigitalIn[count];
        int i = 0;
        while (i < dins.length) {
            dins[i] = this.getDigitalIn(ref + i);
            ++i;
        }
        return dins;
    }

    @Override
    public DigitalIn getDigitalIn(int ref) throws IllegalAddressException {
        try {
            DigitalIn result = this.digitalIns.elementAt(ref);
            if (result == null) {
                throw new IllegalAddressException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public int getDigitalInCount() {
        return this.digitalIns.size();
    }

    @Override
    public InputRegister[] getInputRegisterRange(int ref, int count) {
        if (ref < 0 || ref + count > this.inputRegisters.size()) {
            throw new IllegalAddressException();
        }
        InputRegister[] iregs = new InputRegister[count];
        int i = 0;
        while (i < iregs.length) {
            iregs[i] = this.getInputRegister(ref + i);
            ++i;
        }
        return iregs;
    }

    @Override
    public InputRegister getInputRegister(int ref) throws IllegalAddressException {
        try {
            InputRegister result = this.inputRegisters.elementAt(ref);
            if (result == null) {
                throw new IllegalAddressException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public int getInputRegisterCount() {
        return this.inputRegisters.size();
    }

    @Override
    public Register[] getRegisterRange(int ref, int count) {
        if (ref < 0 || ref + count > this.registers.size()) {
            throw new IllegalAddressException();
        }
        Register[] iregs = new Register[count];
        int i = 0;
        while (i < iregs.length) {
            iregs[i] = this.getRegister(ref + i);
            ++i;
        }
        return iregs;
    }

    @Override
    public Register getRegister(int ref) throws IllegalAddressException {
        try {
            Register result = this.registers.elementAt(ref);
            if (result == null) {
                throw new IllegalAddressException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public int getRegisterCount() {
        return this.registers.size();
    }

    @Override
    public File getFile(int fileNumber) {
        try {
            File result = this.files.elementAt(fileNumber);
            if (result == null) {
                throw new IllegalAddressException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getFileByNumber(int ref) {
        if (ref < 0 || ref >= 10000 || this.files == null) {
            throw new IllegalAddressException();
        }
        Vector<File> vector = this.files;
        synchronized (vector) {
            for (File file : this.files) {
                if (file.getFileNumber() != ref) continue;
                return file;
            }
        }
        throw new IllegalAddressException();
    }

    @Override
    public int getFileCount() {
        return this.files.size();
    }

    @Override
    public FIFO getFIFO(int fifoNumber) {
        try {
            FIFO result = this.fifos.elementAt(fifoNumber);
            if (result == null) {
                throw new IllegalAddressException();
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalAddressException();
        }
    }

    @Override
    public FIFO getFIFOByAddress(int ref) {
        for (FIFO fifo : this.fifos) {
            if (fifo.getAddress() != ref) continue;
            return fifo;
        }
        return null;
    }

    @Override
    public int getFIFOCount() {
        if (this.fifos == null) {
            return 0;
        }
        return this.fifos.size();
    }

    @Override
    public void setDigitalOut(int ref, DigitalOut out) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                if (this.digitalOuts.get(ref) == null) {
                    throw new IllegalAddressException();
                }
                this.digitalOuts.setElementAt(out, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public void addDigitalOut(DigitalOut out) {
        if (!this.isLocked()) {
            this.digitalOuts.addElement(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDigitalOut(int ref, DigitalOut dout) {
        if (ref < 0 || ref >= 65536) {
            throw new IllegalArgumentException();
        }
        if (!this.isLocked()) {
            Vector<DigitalOut> vector = this.digitalOuts;
            synchronized (vector) {
                if (ref < this.digitalOuts.size()) {
                    this.digitalOuts.setElementAt(dout, ref);
                    return;
                }
                this.digitalOuts.setSize(ref + 1);
                this.digitalOuts.setElementAt(dout, ref);
            }
        }
    }

    @Override
    public void removeDigitalOut(DigitalOut out) {
        if (!this.isLocked()) {
            this.digitalOuts.removeElement(out);
        }
    }

    @Override
    public void setDigitalIn(int ref, DigitalIn di) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                if (this.digitalIns.get(ref) == null) {
                    throw new IllegalAddressException();
                }
                this.digitalIns.setElementAt(di, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public void addDigitalIn(DigitalIn di) {
        if (!this.isLocked()) {
            this.digitalIns.addElement(di);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDigitalIn(int ref, DigitalIn d1) {
        if (ref < 0 || ref >= 65536) {
            throw new IllegalArgumentException();
        }
        if (!this.isLocked()) {
            Vector<DigitalIn> vector = this.digitalIns;
            synchronized (vector) {
                if (ref < this.digitalIns.size()) {
                    this.digitalIns.setElementAt(d1, ref);
                    return;
                }
                this.digitalIns.setSize(ref + 1);
                this.digitalIns.setElementAt(d1, ref);
            }
        }
    }

    @Override
    public void removeDigitalIn(DigitalIn di) {
        if (!this.isLocked()) {
            this.digitalIns.removeElement(di);
        }
    }

    @Override
    public void setInputRegister(int ref, InputRegister reg) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                if (this.inputRegisters.get(ref) == null) {
                    throw new IllegalAddressException();
                }
                this.inputRegisters.setElementAt(reg, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public void addInputRegister(InputRegister reg) {
        if (!this.isLocked()) {
            this.inputRegisters.addElement(reg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInputRegister(int ref, InputRegister inReg) {
        if (ref < 0 || ref >= 65536) {
            throw new IllegalArgumentException();
        }
        if (!this.isLocked()) {
            Vector<InputRegister> vector = this.inputRegisters;
            synchronized (vector) {
                if (ref < this.inputRegisters.size()) {
                    this.inputRegisters.setElementAt(inReg, ref);
                    return;
                }
                this.inputRegisters.setSize(ref + 1);
                this.inputRegisters.setElementAt(inReg, ref);
            }
        }
    }

    @Override
    public void removeInputRegister(InputRegister reg) {
        if (!this.isLocked()) {
            this.inputRegisters.removeElement(reg);
        }
    }

    @Override
    public void setRegister(int ref, Register reg) throws IllegalAddressException {
        if (!this.isLocked()) {
            try {
                if (this.registers.get(ref) == null) {
                    throw new IllegalAddressException();
                }
                this.registers.setElementAt(reg, ref);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public void addRegister(Register reg) {
        if (!this.isLocked()) {
            this.registers.addElement(reg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegister(int ref, Register reg) {
        if (ref < 0 || ref >= 65536) {
            throw new IllegalArgumentException();
        }
        if (!this.isLocked()) {
            Vector<Register> vector = this.registers;
            synchronized (vector) {
                if (ref < this.registers.size()) {
                    this.registers.setElementAt(reg, ref);
                    return;
                }
                this.registers.setSize(ref + 1);
                this.registers.setElementAt(reg, ref);
            }
        }
    }

    @Override
    public void removeRegister(Register reg) {
        if (!this.isLocked()) {
            this.registers.removeElement(reg);
        }
    }

    @Override
    public void setFile(int fileNumber, File file) {
        if (!this.isLocked()) {
            try {
                if (this.files.get(fileNumber) == null) {
                    throw new IllegalAddressException();
                }
                this.files.setElementAt(file, fileNumber);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public void addFile(File newFile) {
        if (!this.isLocked()) {
            this.files.add(newFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(int ref, File newFile) {
        if (ref < 0 || ref >= 65536) {
            throw new IllegalArgumentException();
        }
        if (!this.isLocked()) {
            Vector<File> vector = this.files;
            synchronized (vector) {
                if (ref < this.files.size()) {
                    this.files.setElementAt(newFile, ref);
                    return;
                }
                this.files.setSize(ref + 1);
                this.files.setElementAt(newFile, ref);
            }
        }
    }

    @Override
    public void removeFile(File oldFile) {
        if (!this.isLocked()) {
            this.files.removeElement(oldFile);
        }
    }

    @Override
    public void setFIFO(int fifoNumber, FIFO fifo) {
        if (!this.isLocked()) {
            try {
                if (this.fifos.get(fifoNumber) == null) {
                    throw new IllegalAddressException();
                }
                this.fifos.setElementAt(fifo, fifoNumber);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IllegalAddressException();
            }
        }
    }

    @Override
    public void addFIFO(FIFO fifo) {
        if (!this.isLocked()) {
            this.fifos.add(fifo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFIFO(int ref, FIFO newFIFO) {
        if (ref < 0 || ref >= 65536) {
            throw new IllegalArgumentException();
        }
        if (!this.isLocked()) {
            Vector<FIFO> vector = this.fifos;
            synchronized (vector) {
                if (ref < this.fifos.size()) {
                    this.fifos.setElementAt(newFIFO, ref);
                    return;
                }
                this.fifos.setSize(ref + 1);
                this.fifos.setElementAt(newFIFO, ref);
            }
        }
    }

    @Override
    public void removeFIFO(FIFO oldFIFO) {
        if (!this.isLocked()) {
            this.fifos.removeElement(oldFIFO);
        }
    }
}

