/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.procimg;

import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.procimg.SimpleRegister;

public class Record {
    private int recordNumber;
    private int registerCount;
    private Register[] registers;

    public Record(int recordNumber, int registers) {
        this.recordNumber = recordNumber;
        this.registerCount = registers;
        this.registers = new Register[registers];
        int i = 0;
        while (i < this.registerCount) {
            this.registers[i] = new SimpleRegister(0);
            ++i;
        }
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public int getRegisterCount() {
        return this.registerCount;
    }

    public Register getRegister(int register) {
        if (register < 0 || register >= this.registerCount) {
            throw new IllegalAddressException();
        }
        return this.registers[register];
    }

    public Record setRegister(int ref, Register register) {
        if (ref < 0 || ref >= this.registerCount) {
            throw new IllegalAddressException();
        }
        this.registers[ref] = register;
        return this;
    }
}

