/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.procimg;

import java.util.Vector;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.procimg.SimpleRegister;

public class FIFO {
    private int address;
    private int registerCount;
    private Vector<Register> registers;

    public FIFO(int address) {
        this.address = address;
        this.registerCount = 0;
        this.registers = new Vector();
    }

    public synchronized int getRegisterCount() {
        return this.registerCount;
    }

    public synchronized Register[] getRegisters() {
        Register[] result = new Register[this.registerCount + 1];
        result[0] = new SimpleRegister(this.registerCount);
        int i = 0;
        while (i < this.registerCount) {
            result[i + 1] = this.registers.get(i);
            ++i;
        }
        return result;
    }

    public synchronized void pushRegister(Register register) {
        if (this.registerCount == 31) {
            this.registers.remove(0);
        } else {
            ++this.registerCount;
        }
        this.registers.add(new SimpleRegister(register.getValue()));
    }

    public synchronized void resetRegisters() {
        this.registers.removeAllElements();
        this.registerCount = 0;
    }

    public int getAddress() {
        return this.address;
    }
}

