/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.modbus.io.AbstractModbusTransport;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.net.TCPSlaveConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPConnectionHandler
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TCPConnectionHandler.class);
    private TCPSlaveConnection connection;
    private AbstractModbusTransport transport;
    private AbstractModbusListener listener;

    public TCPConnectionHandler(AbstractModbusListener listener, TCPSlaveConnection connection) {
        this.listener = listener;
        this.connection = connection;
        this.transport = this.connection.getModbusTransport();
    }

    @Override
    public void run() {
        try {
            try {
                do {
                    this.listener.handleRequest(this.transport, this.listener);
                } while (!Thread.currentThread().isInterrupted());
            }
            catch (ModbusIOException ex) {
                if (!ex.isEOF()) {
                    logger.debug(ex.getMessage());
                }
                this.connection.close();
            }
        }
        finally {
            this.connection.close();
        }
    }
}

