/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.TreeSet;
import net.wimpi.modbus.modbus.io.AbstractModbusTransport;
import net.wimpi.modbus.modbus.io.ModbusASCIITransport;
import net.wimpi.modbus.modbus.io.ModbusRTUTransport;
import net.wimpi.modbus.modbus.io.ModbusSerialTransport;
import net.wimpi.modbus.net.AbstractSerialConnection;
import net.wimpi.modbus.util.ModbusUtil;
import net.wimpi.modbus.util.SerialParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialConnection
extends AbstractSerialConnection {
    private static final Logger logger = LoggerFactory.getLogger(SerialConnection.class);
    public static final int CONNECT_RETRY_DELAY = 100;
    public static final int CONNECT_RETRIES = 3;
    private SerialParameters parameters;
    private ModbusSerialTransport transport;
    private SerialPort serialPort;
    private InputStream inputStream;
    private int timeout = 3000;

    public SerialConnection() {
    }

    public SerialConnection(SerialParameters parameters) {
        this.parameters = parameters;
    }

    public static AbstractSerialConnection getCommPort(String commPort) {
        SerialConnection jSerialCommPort = new SerialConnection();
        jSerialCommPort.serialPort = SerialPort.getCommPort((String)commPort);
        return jSerialCommPort;
    }

    @Override
    public AbstractModbusTransport getModbusTransport() {
        return this.transport;
    }

    @Override
    public synchronized void open() throws IOException {
        if (this.serialPort == null) {
            this.serialPort = SerialPort.getCommPort((String)this.parameters.getPortName());
            if (this.serialPort.getDescriptivePortName().contains("Bad Port")) {
                this.close();
                throw new IOException(String.format("Port %s is not a valid name for a port on this platform", this.parameters.getPortName()));
            }
        }
        this.serialPort.closePort();
        this.applyConnectionParameters();
        if ("ascii".equals(this.parameters.getEncoding())) {
            this.transport = new ModbusASCIITransport();
        } else if ("rtu".equals(this.parameters.getEncoding())) {
            this.transport = new ModbusRTUTransport();
        } else {
            this.transport = new ModbusRTUTransport();
            logger.warn("Unknown transport encoding [{}] - reverting to RTU", (Object)this.parameters.getEncoding());
        }
        this.transport.setEcho(this.parameters.isEcho());
        this.transport.setTimeout(this.timeout);
        this.transport.setCommPort(this);
        int attempts = 0;
        while (!this.serialPort.openPort(this.parameters.getOpenDelay()) && attempts < 3) {
            this.serialPort.closePort();
            ModbusUtil.sleep(100L);
            logger.debug("Retrying to open port [{}] - attempt [{}}", (Object)this.parameters.getPortName(), (Object)(++attempts));
        }
        if (!this.serialPort.isOpen()) {
            Set<String> ports = this.getCommPorts();
            StringBuilder portList = new StringBuilder("<NONE>");
            if (!ports.isEmpty()) {
                portList = new StringBuilder();
                for (String port : ports) {
                    portList.append(portList.length() == 0 ? "" : ",").append(port);
                }
            }
            throw new IOException(String.format("Port [%s] cannot be opened after [%d] attempts - valid ports are: [%s]", this.parameters.getPortName(), attempts, portList.toString()));
        }
        this.inputStream = this.serialPort.getInputStream();
    }

    private void applyConnectionParameters() {
        if (this.serialPort != null) {
            this.serialPort.setComPortParameters(this.parameters.getBaudRate(), this.parameters.getDatabits(), this.parameters.getStopbits(), this.parameters.getParity());
            this.serialPort.setFlowControl(this.parameters.getFlowControlIn() | this.parameters.getFlowControlOut());
        }
    }

    @Override
    public synchronized void close() {
        block7: {
            if (this.serialPort != null) {
                try {
                    try {
                        if (this.inputStream != null) {
                            this.inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        logger.debug(e.getMessage());
                        this.serialPort.closePort();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.serialPort.closePort();
                    throw throwable;
                }
                this.serialPort.closePort();
            }
        }
        this.serialPort = null;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.serialPort != null && this.serialPort.isOpen();
    }

    @Override
    public synchronized int getTimeout() {
        return this.timeout;
    }

    @Override
    public synchronized void setTimeout(int timeout) {
        this.timeout = timeout;
        if (this.transport != null) {
            this.transport.setTimeout(timeout);
        }
    }

    @Override
    public int readBytes(byte[] buffer, long bytesToRead) {
        return this.serialPort == null ? 0 : this.serialPort.readBytes(buffer, bytesToRead);
    }

    @Override
    public int writeBytes(byte[] buffer, long bytesToWrite) {
        return this.serialPort == null ? 0 : this.serialPort.writeBytes(buffer, bytesToWrite);
    }

    @Override
    public int bytesAvailable() {
        return this.serialPort == null ? 0 : this.serialPort.bytesAvailable();
    }

    @Override
    public int getBaudRate() {
        return this.parameters.getBaudRate();
    }

    @Override
    public int getNumDataBits() {
        return this.parameters.getDatabits();
    }

    @Override
    public int getNumStopBits() {
        return this.parameters.getStopbits();
    }

    @Override
    public int getParity() {
        return this.parameters.getParity();
    }

    @Override
    public String getPortName() {
        return this.parameters.getPortName();
    }

    @Override
    public String getDescriptivePortName() {
        return this.serialPort == null ? this.parameters.getPortName() : this.serialPort.getDescriptivePortName();
    }

    @Override
    public void setComPortTimeouts(int newTimeoutMode, int newReadTimeout, int newWriteTimeout) {
        if (this.serialPort != null) {
            this.serialPort.setComPortTimeouts(newTimeoutMode, newReadTimeout, newWriteTimeout);
        }
    }

    @Override
    public Set<String> getCommPorts() {
        TreeSet<String> returnValue = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        SerialPort[] ports = SerialPort.getCommPorts();
        if (ports != null && ports.length > 0) {
            SerialPort[] serialPortArray = ports;
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                SerialPort port = serialPortArray[n2];
                returnValue.add(port.getSystemPortName());
                ++n2;
            }
        }
        return returnValue;
    }
}

