/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.modbus.io.ModbusUDPTransport;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.net.UDPSlaveTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusUDPListener
extends AbstractModbusListener {
    private static final Logger logger = LoggerFactory.getLogger(ModbusUDPListener.class);
    private UDPSlaveTerminal terminal;

    public ModbusUDPListener(InetAddress ifc) {
        this.address = ifc;
        this.listening = true;
    }

    public ModbusUDPListener() {
        try {
            this.address = InetAddress.getByAddress(new byte[4]);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Override
    public void setTimeout(int timeout) {
        super.setTimeout(timeout);
        if (this.terminal != null && this.listening) {
            this.terminal.setTimeout(timeout);
        }
    }

    @Override
    public void run() {
        ModbusUDPTransport transport;
        if (this.threadName == null || this.threadName.isEmpty()) {
            this.threadName = String.format("Modbus UDP Listener [port:%d]", this.port);
        }
        Thread.currentThread().setName(this.threadName);
        try {
            this.terminal = this.address == null ? new UDPSlaveTerminal(InetAddress.getByAddress(new byte[4])) : new UDPSlaveTerminal(this.address);
            this.terminal.setTimeout(this.timeout);
            this.terminal.setPort(this.port);
            this.terminal.activate();
            transport = new ModbusUDPTransport(this.terminal);
        }
        catch (Exception e) {
            this.error = String.format("Cannot start UDP listener - %s", e.getMessage());
            this.listening = false;
            return;
        }
        this.listening = true;
        try {
            try {
                while (this.listening) {
                    this.handleRequest(transport, this);
                }
            }
            catch (ModbusIOException ex1) {
                if (!ex1.isEOF()) {
                    logger.error("Exception occurred before EOF while handling request", (Throwable)ex1);
                }
                try {
                    this.terminal.deactivate();
                    transport.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                this.terminal.deactivate();
                transport.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void stop() {
        this.terminal.deactivate();
        this.listening = false;
    }
}

