/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.net.TCPConnectionHandler;
import net.wimpi.modbus.net.TCPSlaveConnection;
import net.wimpi.modbus.util.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTCPListener
extends AbstractModbusListener {
    private static final Logger logger = LoggerFactory.getLogger(ModbusTCPListener.class);
    private ServerSocket serverSocket = null;
    private ThreadPool threadPool;
    private Thread listener;
    private boolean useRtuOverTcp;

    public ModbusTCPListener(int poolsize, InetAddress addr) {
        this(poolsize, addr, false);
    }

    public ModbusTCPListener(int poolsize, InetAddress addr, boolean useRtuOverTcp) {
        this.threadPool = new ThreadPool(poolsize);
        this.address = addr;
        this.useRtuOverTcp = useRtuOverTcp;
    }

    public ModbusTCPListener(int poolsize) {
        this(poolsize, false);
    }

    public ModbusTCPListener(int poolsize, boolean useRtuOverTcp) {
        this.threadPool = new ThreadPool(poolsize);
        try {
            this.address = InetAddress.getByAddress(new byte[4]);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.useRtuOverTcp = useRtuOverTcp;
    }

    @Override
    public void setTimeout(int timeout) {
        super.setTimeout(timeout);
        if (this.serverSocket != null && this.listening) {
            try {
                this.serverSocket.setSoTimeout(timeout);
            }
            catch (SocketException e) {
                logger.error("Cannot set socket timeout", (Throwable)e);
            }
        }
    }

    @Override
    public void run() {
        if (this.threadName == null || this.threadName.isEmpty()) {
            this.threadName = String.format("Modbus TCP Listener [port:%d]", this.port);
        }
        Thread.currentThread().setName(this.threadName);
        try {
            int floodProtection = 100;
            this.serverSocket = new ServerSocket(this.port, floodProtection, this.address);
            this.serverSocket.setSoTimeout(this.timeout);
            logger.debug("Listening to {} (Port {})", (Object)this.serverSocket, (Object)this.port);
        }
        catch (Exception e) {
            this.error = String.format("Cannot start TCP listener - %s", e.getMessage());
            this.listening = false;
            return;
        }
        this.listener = Thread.currentThread();
        this.listening = true;
        try {
            try {
                this.threadPool.initPool(this.threadName);
                while (this.listening) {
                    Socket incoming;
                    try {
                        incoming = this.serverSocket.accept();
                    }
                    catch (SocketTimeoutException e) {
                        continue;
                    }
                    logger.debug("Making new connection {}", (Object)incoming);
                    if (this.listening) {
                        TCPSlaveConnection slave = new TCPSlaveConnection(incoming, this.useRtuOverTcp);
                        slave.setTimeout(this.timeout);
                        this.threadPool.execute(new TCPConnectionHandler(this, slave));
                        continue;
                    }
                    incoming.close();
                }
            }
            catch (IOException e) {
                this.error = String.format("Problem starting listener - %s", e.getMessage());
                this.threadPool.close();
            }
        }
        finally {
            this.threadPool.close();
        }
    }

    @Override
    public void stop() {
        this.listening = false;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
            if (this.listener != null) {
                this.listener.join();
            }
            if (this.threadPool != null) {
                this.threadPool.close();
            }
        }
        catch (Exception ex) {
            logger.error("Error while stopping ModbusTCPListener", (Throwable)ex);
        }
    }
}

