/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.modbus.io.AbstractModbusTransport;
import net.wimpi.modbus.modbus.io.ModbusSerialTransport;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.net.AbstractSerialConnection;
import net.wimpi.modbus.net.SerialConnection;
import net.wimpi.modbus.util.SerialParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusSerialListener
extends AbstractModbusListener {
    private static final Logger logger = LoggerFactory.getLogger(ModbusSerialListener.class);
    private AbstractSerialConnection serialCon;

    public ModbusSerialListener(SerialParameters params) {
        this.serialCon = new SerialConnection(params);
    }

    public ModbusSerialListener(AbstractSerialConnection serialCon) {
        this.serialCon = serialCon;
    }

    @Override
    public void setTimeout(int timeout) {
        ModbusSerialTransport transport;
        super.setTimeout(timeout);
        if (this.serialCon != null && this.listening && (transport = (ModbusSerialTransport)this.serialCon.getModbusTransport()) != null) {
            transport.setTimeout(timeout);
        }
    }

    @Override
    public void run() {
        if (this.threadName == null || this.threadName.isEmpty()) {
            this.threadName = String.format("Modbus Serial Listener [port:%s]", this.serialCon.getDescriptivePortName());
        }
        Thread.currentThread().setName(this.threadName);
        try {
            this.serialCon.open();
        }
        catch (Exception e) {
            this.error = String.format("Cannot start Serial listener - %s", e.getMessage());
            this.listening = false;
            return;
        }
        this.listening = true;
        try {
            try {
                AbstractModbusTransport transport = this.serialCon.getModbusTransport();
                while (this.listening) {
                    this.safeHandleRequest(transport);
                }
            }
            catch (Exception e) {
                logger.error("Exception occurred while handling request.", (Throwable)e);
                this.listening = false;
                this.serialCon.close();
            }
        }
        finally {
            this.listening = false;
            this.serialCon.close();
        }
    }

    private void safeHandleRequest(AbstractModbusTransport transport) {
        try {
            this.handleRequest(transport, this);
        }
        catch (ModbusIOException ex) {
            logger.debug(ex.getMessage());
        }
    }

    @Override
    public void stop() {
        if (this.serialCon != null) {
            this.serialCon.close();
        }
        this.listening = false;
    }
}

