/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.WriteMultipleCoilsResponse;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.procimg.DigitalOut;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;
import net.wimpi.modbus.util.BitVector;

public class WriteMultipleCoilsRequest
extends ModbusRequest {
    private int reference;
    private BitVector coils;

    public WriteMultipleCoilsRequest(int ref, BitVector bv) {
        this.setFunctionCode(15);
        this.setDataLength(bv.byteSize() + 5);
        this.setReference(ref);
        this.coils = bv;
    }

    public WriteMultipleCoilsRequest(int ref, int count) {
        this.setFunctionCode(15);
        this.setDataLength((count + 7) / 8 + 5);
        this.setReference(ref);
        this.coils = new BitVector(count);
    }

    public WriteMultipleCoilsRequest() {
        this.setFunctionCode(15);
        this.setDataLength(5);
        this.coils = new BitVector(1);
    }

    @Override
    public ModbusResponse getResponse() {
        return this.updateResponseWithHeader(new WriteMultipleCoilsResponse());
    }

    @Override
    public ModbusResponse createResponse(AbstractModbusListener listener) {
        ProcessImage procimg = listener.getProcessImage(this.getUnitID());
        try {
            DigitalOut[] douts = procimg.getDigitalOutRange(this.reference, this.coils.size());
            int i = 0;
            while (i < douts.length) {
                douts[i].set(this.coils.getBit(i));
                ++i;
            }
        }
        catch (IllegalAddressException iaex) {
            return this.createExceptionResponse(2);
        }
        WriteMultipleCoilsResponse response = (WriteMultipleCoilsResponse)this.getResponse();
        response.setBitCount(this.coils.size());
        response.setReference(this.reference);
        return response;
    }

    public int getReference() {
        return this.reference;
    }

    public void setReference(int ref) {
        this.reference = ref;
    }

    public int getBitCount() {
        if (this.coils == null) {
            return 0;
        }
        return this.coils.size();
    }

    public int getByteCount() {
        return this.coils.byteSize();
    }

    public boolean getCoilStatus(int index) throws IndexOutOfBoundsException {
        return this.coils.getBit(index);
    }

    public void setCoilStatus(int index, boolean b) throws IndexOutOfBoundsException {
        this.coils.setBit(index, b);
    }

    public BitVector getCoils() {
        return this.coils;
    }

    public void setCoils(BitVector bv) {
        this.coils = bv;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.reference);
        dout.writeShort(this.coils.size());
        dout.writeByte(this.coils.byteSize());
        dout.write(this.coils.getBytes());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.reference = din.readUnsignedShort();
        int bitcount = din.readUnsignedShort();
        int coilBytes = din.readUnsignedByte();
        byte[] data = new byte[coilBytes];
        int k = 0;
        while (k < coilBytes) {
            data[k] = din.readByte();
            ++k;
        }
        this.coils = BitVector.createBitVector(data, bitcount);
        this.setDataLength(coilBytes + 5);
    }

    @Override
    public byte[] getMessage() {
        int len = this.coils.byteSize() + 5;
        byte[] result = new byte[len];
        result[0] = (byte)(this.reference >> 8 & 0xFF);
        result[1] = (byte)(this.reference & 0xFF);
        result[2] = (byte)(this.coils.size() >> 8 & 0xFF);
        result[3] = (byte)(this.coils.size() & 0xFF);
        result[4] = (byte)this.coils.byteSize();
        System.arraycopy(this.coils.getBytes(), 0, result, 5, this.coils.byteSize());
        return result;
    }
}

