/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import net.wimpi.modbus.modbus.io.NonWordDataHandler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadWriteMultipleResponse;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.InputRegister;
import net.wimpi.modbus.procimg.ProcessImage;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.procimg.SimpleInputRegister;
import net.wimpi.modbus.procimg.SimpleRegister;

public class ReadWriteMultipleRequest
extends ModbusRequest {
    private NonWordDataHandler nonWordDataHandler;
    private int readReference;
    private int readCount;
    private int writeReference;
    private int writeCount;
    private Register[] registers;

    public ReadWriteMultipleRequest(int unit, int readRef, int readCount, int writeRef, int writeCount) {
        this.setUnitID(unit);
        this.setFunctionCode(23);
        this.setDataLength(9 + writeCount * 2);
        this.readReference = readRef;
        this.readCount = readCount;
        this.writeReference = writeRef;
        this.writeCount = writeCount;
        this.registers = new Register[writeCount];
        int i = 0;
        while (i < writeCount) {
            this.registers[i] = new SimpleRegister(0);
            ++i;
        }
    }

    public ReadWriteMultipleRequest(int unit) {
        this.setUnitID(unit);
        this.setFunctionCode(23);
        this.setDataLength(9);
    }

    public ReadWriteMultipleRequest() {
        this.setFunctionCode(23);
        this.setDataLength(9);
    }

    @Override
    public ModbusResponse getResponse() {
        return this.updateResponseWithHeader(new ReadWriteMultipleResponse());
    }

    @Override
    public ModbusResponse createResponse(AbstractModbusListener listener) {
        InputRegister[] readRegs;
        ProcessImage procimg = listener.getProcessImage(this.getUnitID());
        try {
            Register[] writeRegs = procimg.getRegisterRange(this.getWriteReference(), this.getWriteWordCount());
            int i = 0;
            while (i < writeRegs.length) {
                writeRegs[i].setValue(this.getRegister(i).getValue());
                ++i;
            }
            readRegs = procimg.getRegisterRange(this.getReadReference(), this.getReadWordCount());
            InputRegister[] dummy = new InputRegister[readRegs.length];
            int i2 = 0;
            while (i2 < readRegs.length) {
                dummy[i2] = new SimpleInputRegister(readRegs[i2].getValue());
                ++i2;
            }
            readRegs = dummy;
        }
        catch (IllegalAddressException e) {
            return this.createExceptionResponse(2);
        }
        ReadWriteMultipleResponse response = (ReadWriteMultipleResponse)this.getResponse();
        response.setRegisters(readRegs);
        return response;
    }

    public int getReadReference() {
        return this.readReference;
    }

    public void setReadReference(int ref) {
        this.readReference = ref;
    }

    public int getWriteReference() {
        return this.writeReference;
    }

    public void setWriteReference(int ref) {
        this.writeReference = ref;
    }

    public synchronized Register[] getRegisters() {
        Register[] dest = new Register[this.registers.length];
        System.arraycopy(this.registers, 0, dest, 0, dest.length);
        return dest;
    }

    public synchronized void setRegisters(Register[] registers) {
        this.writeCount = registers != null ? registers.length : 0;
        this.registers = registers != null ? Arrays.copyOf(registers, registers.length) : null;
    }

    public Register getRegister(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " < 0");
        }
        if (index >= this.getWriteWordCount()) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " > " + this.getWriteWordCount());
        }
        return this.registers[index];
    }

    public int getReadRegisterValue(int index) throws IndexOutOfBoundsException {
        return this.getRegister(index).toUnsignedShort();
    }

    public int getByteCount() {
        return this.getWriteWordCount() * 2;
    }

    public int getWriteWordCount() {
        return this.writeCount;
    }

    public void setWriteWordCount(int count) {
        this.writeCount = count;
    }

    public int getReadWordCount() {
        return this.readCount;
    }

    public void setReadWordCount(int count) {
        this.readCount = count;
    }

    public NonWordDataHandler getNonWordDataHandler() {
        return this.nonWordDataHandler;
    }

    public void setNonWordDataHandler(NonWordDataHandler dhandler) {
        this.nonWordDataHandler = dhandler;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput input) throws IOException {
        this.readReference = input.readUnsignedShort();
        this.readCount = input.readUnsignedShort();
        this.writeReference = input.readUnsignedShort();
        this.writeCount = input.readUnsignedShort();
        int byteCount = input.readUnsignedByte();
        if (this.nonWordDataHandler == null) {
            byte[] buffer = new byte[byteCount];
            input.readFully(buffer, 0, byteCount);
            int offset = 0;
            this.registers = new Register[this.writeCount];
            int register = 0;
            while (register < this.writeCount) {
                this.registers[register] = new SimpleRegister(buffer[offset], buffer[offset + 1]);
                offset += 2;
                ++register;
            }
        } else {
            this.nonWordDataHandler.readData(input, this.writeReference, this.writeCount);
        }
    }

    @Override
    public byte[] getMessage() {
        byte[] results = new byte[9 + 2 * this.getWriteWordCount()];
        results[0] = (byte)(this.readReference >> 8);
        results[1] = (byte)(this.readReference & 0xFF);
        results[2] = (byte)(this.readCount >> 8);
        results[3] = (byte)(this.readCount & 0xFF);
        results[4] = (byte)(this.writeReference >> 8);
        results[5] = (byte)(this.writeReference & 0xFF);
        results[6] = (byte)(this.writeCount >> 8);
        results[7] = (byte)(this.writeCount & 0xFF);
        results[8] = (byte)(this.writeCount * 2);
        int offset = 9;
        int i = 0;
        while (i < this.writeCount) {
            Register reg = this.getRegister(i);
            byte[] bytes = reg.toBytes();
            results[offset++] = bytes[0];
            results[offset++] = bytes[1];
            ++i;
        }
        return results;
    }
}

