/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadMultipleRegistersResponse;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;
import net.wimpi.modbus.procimg.Register;

public class ReadMultipleRegistersRequest
extends ModbusRequest {
    private int reference;
    private int wordCount;

    public ReadMultipleRegistersRequest() {
        this.setFunctionCode(3);
        this.setDataLength(4);
    }

    public ReadMultipleRegistersRequest(int ref, int count) {
        this.setFunctionCode(3);
        this.setDataLength(4);
        this.setReference(ref);
        this.setWordCount(count);
    }

    @Override
    public ModbusResponse getResponse() {
        return this.updateResponseWithHeader(new ReadMultipleRegistersResponse());
    }

    @Override
    public ModbusResponse createResponse(AbstractModbusListener listener) {
        Register[] regs;
        ProcessImage procimg = listener.getProcessImage(this.getUnitID());
        try {
            regs = procimg.getRegisterRange(this.getReference(), this.getWordCount());
        }
        catch (IllegalAddressException e) {
            return this.createExceptionResponse(2);
        }
        ReadMultipleRegistersResponse response = (ReadMultipleRegistersResponse)this.getResponse();
        response.setRegisters(regs);
        return response;
    }

    public int getReference() {
        return this.reference;
    }

    public void setReference(int ref) {
        this.reference = ref;
    }

    public int getWordCount() {
        return this.wordCount;
    }

    public void setWordCount(int count) {
        this.wordCount = count;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.reference);
        dout.writeShort(this.wordCount);
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.reference = din.readUnsignedShort();
        this.wordCount = din.readUnsignedShort();
    }

    @Override
    public byte[] getMessage() {
        byte[] result = new byte[]{(byte)(this.reference >> 8 & 0xFF), (byte)(this.reference & 0xFF), (byte)(this.wordCount >> 8 & 0xFF), (byte)(this.wordCount & 0xFF)};
        return result;
    }
}

