/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.msg.IllegalFunctionExceptionResponse;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadMEIResponse;
import net.wimpi.modbus.net.AbstractModbusListener;

public class ReadMEIRequest
extends ModbusRequest {
    private int subCode;
    private int fieldLevel;
    private int fieldId;

    public ReadMEIRequest() {
        this.setFunctionCode(43);
        this.subCode = 14;
        this.setDataLength(3);
    }

    public ReadMEIRequest(int level, int id) {
        this.setFunctionCode(43);
        this.subCode = 14;
        this.setDataLength(3);
        this.setLevel(level);
        this.setFieldId(id);
    }

    @Override
    public ModbusResponse getResponse() {
        if (this.getSubCode() != 14) {
            IllegalFunctionExceptionResponse error = new IllegalFunctionExceptionResponse();
            return this.updateResponseWithHeader(error);
        }
        return this.updateResponseWithHeader(new ReadMEIResponse());
    }

    @Override
    public ModbusResponse createResponse(AbstractModbusListener listener) {
        return this.createExceptionResponse(1);
    }

    public int getSubCode() {
        return this.subCode;
    }

    public int getLevel() {
        return this.fieldLevel;
    }

    public void setLevel(int level) {
        this.fieldLevel = level;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(int id) {
        this.fieldId = id;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        byte[] results = new byte[]{(byte)this.subCode, (byte)this.fieldLevel, (byte)this.fieldId};
        dout.write(results);
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.subCode = din.readUnsignedByte();
        if (this.subCode != 14) {
            try {
                while (din.readByte() >= 0) {
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return;
        }
        this.fieldLevel = din.readUnsignedByte();
        this.fieldId = din.readUnsignedByte();
    }

    @Override
    public byte[] getMessage() {
        byte[] results = new byte[]{(byte)this.subCode, (byte)this.fieldLevel, (byte)this.fieldId};
        return results;
    }
}

