/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadInputDiscretesResponse;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.procimg.DigitalIn;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;

public class ReadInputDiscretesRequest
extends ModbusRequest {
    private int reference;
    private int bitCount;

    public ReadInputDiscretesRequest() {
        this.setFunctionCode(2);
        this.setDataLength(4);
    }

    public ReadInputDiscretesRequest(int ref, int count) {
        this.setFunctionCode(2);
        this.setDataLength(4);
        this.setReference(ref);
        this.setBitCount(count);
    }

    @Override
    public ModbusResponse getResponse() {
        return this.updateResponseWithHeader(new ReadInputDiscretesResponse(this.getBitCount()));
    }

    @Override
    public ModbusResponse createResponse(AbstractModbusListener listener) {
        DigitalIn[] dins;
        ProcessImage procimg = listener.getProcessImage(this.getUnitID());
        try {
            dins = procimg.getDigitalInRange(this.getReference(), this.getBitCount());
        }
        catch (IllegalAddressException e) {
            return this.createExceptionResponse(2);
        }
        ReadInputDiscretesResponse response = (ReadInputDiscretesResponse)this.getResponse();
        int i = 0;
        while (i < dins.length) {
            response.setDiscreteStatus(i, dins[i].isSet());
            ++i;
        }
        return response;
    }

    public int getReference() {
        return this.reference;
    }

    public void setReference(int ref) {
        if (ref < 0 || this.bitCount + ref > 65536) {
            throw new IllegalArgumentException();
        }
        this.reference = ref;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public void setBitCount(int count) {
        if (count < 0 || count > 2000 || count + this.reference > 65536) {
            throw new IllegalArgumentException();
        }
        this.bitCount = count;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.reference);
        dout.writeShort(this.bitCount);
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.reference = din.readUnsignedShort();
        this.bitCount = din.readUnsignedShort();
    }

    @Override
    public byte[] getMessage() {
        byte[] result = new byte[]{(byte)(this.reference >> 8 & 0xFF), (byte)(this.reference & 0xFF), (byte)(this.bitCount >> 8 & 0xFF), (byte)(this.bitCount & 0xFF)};
        return result;
    }
}

