/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadFileRecordResponse;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.procimg.File;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;
import net.wimpi.modbus.procimg.Record;
import net.wimpi.modbus.procimg.Register;

public class ReadFileRecordRequest
extends ModbusRequest {
    private RecordRequest[] records;

    public ReadFileRecordRequest() {
        this.setFunctionCode(20);
        this.setDataLength(1);
    }

    public int getRequestSize() {
        if (this.records == null) {
            return 1;
        }
        int size = 1;
        RecordRequest[] recordRequestArray = this.records;
        int n = this.records.length;
        int n2 = 0;
        while (n2 < n) {
            RecordRequest record = recordRequestArray[n2];
            size += record.getRequestSize();
            ++n2;
        }
        return size;
    }

    public int getRequestCount() {
        if (this.records == null) {
            return 0;
        }
        return this.records.length;
    }

    public RecordRequest getRecord(int index) {
        return this.records[index];
    }

    public void addRequest(RecordRequest request) {
        if (request.getRequestSize() + this.getRequestSize() > 248) {
            throw new IllegalArgumentException();
        }
        if (this.records == null) {
            this.records = new RecordRequest[1];
        } else {
            RecordRequest[] old = this.records;
            this.records = new RecordRequest[old.length + 1];
            System.arraycopy(old, 0, this.records, 0, old.length);
        }
        this.records[this.records.length - 1] = request;
        this.setDataLength(this.getRequestSize());
    }

    @Override
    public ModbusResponse getResponse() {
        return this.updateResponseWithHeader(new ReadFileRecordResponse());
    }

    @Override
    public ModbusResponse createResponse(AbstractModbusListener listener) {
        ReadFileRecordResponse response = (ReadFileRecordResponse)this.getResponse();
        ProcessImage procimg = listener.getProcessImage(this.getUnitID());
        try {
            int i = 0;
            while (i < this.getRequestCount()) {
                RecordRequest recordRequest = this.getRecord(i);
                if (recordRequest.getFileNumber() < 0 || recordRequest.getFileNumber() >= procimg.getFileCount()) {
                    return this.createExceptionResponse(2);
                }
                File file = procimg.getFileByNumber(recordRequest.getFileNumber());
                if (recordRequest.getRecordNumber() < 0 || recordRequest.getRecordNumber() >= file.getRecordCount()) {
                    return this.createExceptionResponse(2);
                }
                Record record = file.getRecord(recordRequest.getRecordNumber());
                int registers = recordRequest.getWordCount();
                if (record == null && registers != 0) {
                    return this.createExceptionResponse(2);
                }
                short[] data = new short[registers];
                int j = 0;
                while (j < registers) {
                    Register register = record.getRegister(j);
                    if (register == null) {
                        return this.createExceptionResponse(2);
                    }
                    data[j] = register.toShort();
                    ++j;
                }
                ReadFileRecordResponse.RecordResponse recordResponse = new ReadFileRecordResponse.RecordResponse(data);
                response.addResponse(recordResponse);
                ++i;
            }
        }
        catch (IllegalAddressException e) {
            return this.createExceptionResponse(2);
        }
        return response;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        int byteCount = din.readUnsignedByte();
        int recordCount = byteCount / 7;
        this.records = new RecordRequest[recordCount];
        int i = 0;
        while (i < recordCount) {
            if (din.readByte() != 6) {
                throw new IOException();
            }
            int file = din.readUnsignedShort();
            int record = din.readUnsignedShort();
            if (record < 0 || record >= 10000) {
                throw new IOException();
            }
            int count = din.readUnsignedShort();
            this.records[i] = new RecordRequest(file, record, count);
            ++i;
        }
    }

    @Override
    public byte[] getMessage() {
        byte[] request = new byte[1 + 7 * this.records.length];
        int offset = 0;
        request[offset++] = (byte)(request.length - 1);
        RecordRequest[] recordRequestArray = this.records;
        int n = this.records.length;
        int n2 = 0;
        while (n2 < n) {
            RecordRequest record = recordRequestArray[n2];
            record.getRequest(request, offset);
            offset += 7;
            ++n2;
        }
        return request;
    }

    public static class RecordRequest {
        private int fileNumber;
        private int recordNumber;
        private int wordCount;

        public RecordRequest(int file, int record, int count) {
            this.fileNumber = file;
            this.recordNumber = record;
            this.wordCount = count;
        }

        public int getFileNumber() {
            return this.fileNumber;
        }

        public int getRecordNumber() {
            return this.recordNumber;
        }

        public int getWordCount() {
            return this.wordCount;
        }

        public int getRequestSize() {
            return 7 + this.wordCount * 2;
        }

        public void getRequest(byte[] request, int offset) {
            request[offset] = 6;
            request[offset + 1] = (byte)(this.fileNumber >> 8);
            request[offset + 2] = (byte)(this.fileNumber & 0xFF);
            request[offset + 3] = (byte)(this.recordNumber >> 8);
            request[offset + 4] = (byte)(this.recordNumber & 0xFF);
            request[offset + 5] = (byte)(this.wordCount >> 8);
            request[offset + 6] = (byte)(this.wordCount & 0xFF);
        }

        public byte[] getRequest() {
            byte[] request = new byte[7];
            this.getRequest(request, 0);
            return request;
        }
    }
}

