/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadFIFOQueueResponse;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.InputRegister;
import net.wimpi.modbus.procimg.ProcessImage;
import net.wimpi.modbus.procimg.Register;

public class ReadFIFOQueueRequest
extends ModbusRequest {
    private int reference;

    public ReadFIFOQueueRequest() {
        this.setFunctionCode(24);
        this.setDataLength(2);
    }

    public int getReference() {
        return this.reference;
    }

    public void setReference(int ref) {
        this.reference = ref;
    }

    @Override
    public ModbusResponse getResponse() {
        return this.updateResponseWithHeader(new ReadFIFOQueueResponse());
    }

    @Override
    public ModbusResponse createResponse(AbstractModbusListener listener) {
        InputRegister[] registers;
        ProcessImage procimg = listener.getProcessImage(this.getUnitID());
        try {
            Register queue = procimg.getRegister(this.reference);
            int count = queue.getValue();
            if (count < 0 || count > 31) {
                return this.createExceptionResponse(3);
            }
            registers = procimg.getRegisterRange(this.reference + 1, count);
        }
        catch (IllegalAddressException e) {
            return this.createExceptionResponse(2);
        }
        ReadFIFOQueueResponse response = (ReadFIFOQueueResponse)this.getResponse();
        response.setRegisters(registers);
        return response;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.reference = din.readUnsignedShort();
    }

    @Override
    public byte[] getMessage() {
        byte[] results = new byte[]{(byte)(this.reference >> 8), (byte)(this.reference & 0xFF)};
        return results;
    }
}

