/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadCoilsResponse;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.procimg.DigitalOut;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;

public class ReadCoilsRequest
extends ModbusRequest {
    private int reference;
    private int bitCount;

    public ReadCoilsRequest() {
        this.setFunctionCode(1);
        this.setDataLength(4);
    }

    public ReadCoilsRequest(int ref, int count) {
        this.setFunctionCode(1);
        this.setDataLength(4);
        this.setReference(ref);
        this.setBitCount(count);
    }

    @Override
    public ModbusResponse getResponse() {
        return this.updateResponseWithHeader(new ReadCoilsResponse(this.bitCount));
    }

    @Override
    public ModbusResponse createResponse(AbstractModbusListener listener) {
        DigitalOut[] douts;
        ProcessImage procimg = listener.getProcessImage(this.getUnitID());
        try {
            douts = procimg.getDigitalOutRange(this.getReference(), this.getBitCount());
        }
        catch (IllegalAddressException e) {
            return this.createExceptionResponse(2);
        }
        ModbusResponse response = this.getResponse();
        int i = 0;
        while (i < douts.length) {
            ((ReadCoilsResponse)response).setCoilStatus(i, douts[i].isSet());
            ++i;
        }
        return response;
    }

    public int getReference() {
        return this.reference;
    }

    public void setReference(int ref) {
        this.reference = ref;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public void setBitCount(int count) {
        if (count > 2000) {
            throw new IllegalArgumentException("Maximum bitcount exceeded");
        }
        this.bitCount = count;
    }

    @Override
    public void writeData(DataOutput dout) throws IOException {
        dout.write(this.getMessage());
    }

    @Override
    public void readData(DataInput din) throws IOException {
        this.reference = din.readUnsignedShort();
        this.bitCount = din.readUnsignedShort();
    }

    @Override
    public byte[] getMessage() {
        byte[] result = new byte[]{(byte)(this.reference >> 8 & 0xFF), (byte)(this.reference & 0xFF), (byte)(this.bitCount >> 8 & 0xFF), (byte)(this.bitCount & 0xFF)};
        return result;
    }
}

