/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.wimpi.modbus.msg.ExceptionResponse;
import net.wimpi.modbus.msg.MaskWriteRegisterResponse;
import net.wimpi.modbus.msg.ModbusMessageImpl;
import net.wimpi.modbus.msg.ReadCoilsResponse;
import net.wimpi.modbus.msg.ReadCommEventCounterResponse;
import net.wimpi.modbus.msg.ReadCommEventLogResponse;
import net.wimpi.modbus.msg.ReadExceptionStatusResponse;
import net.wimpi.modbus.msg.ReadFIFOQueueResponse;
import net.wimpi.modbus.msg.ReadFileRecordResponse;
import net.wimpi.modbus.msg.ReadInputDiscretesResponse;
import net.wimpi.modbus.msg.ReadInputRegistersResponse;
import net.wimpi.modbus.msg.ReadMEIResponse;
import net.wimpi.modbus.msg.ReadMultipleRegistersResponse;
import net.wimpi.modbus.msg.ReadSerialDiagnosticsResponse;
import net.wimpi.modbus.msg.ReadWriteMultipleResponse;
import net.wimpi.modbus.msg.ReportSlaveIDResponse;
import net.wimpi.modbus.msg.WriteCoilResponse;
import net.wimpi.modbus.msg.WriteFileRecordResponse;
import net.wimpi.modbus.msg.WriteMultipleCoilsResponse;
import net.wimpi.modbus.msg.WriteMultipleRegistersResponse;
import net.wimpi.modbus.msg.WriteSingleRegisterResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModbusResponse
extends ModbusMessageImpl {
    private static final Logger logger = LoggerFactory.getLogger(ModbusResponse.class);
    private AuxiliaryMessageTypes auxiliaryType = AuxiliaryMessageTypes.NONE;

    public static ModbusResponse createModbusResponse(int functionCode) {
        ModbusResponse response;
        switch (functionCode) {
            case 1: {
                response = new ReadCoilsResponse();
                break;
            }
            case 2: {
                response = new ReadInputDiscretesResponse();
                break;
            }
            case 3: {
                response = new ReadMultipleRegistersResponse();
                break;
            }
            case 4: {
                response = new ReadInputRegistersResponse();
                break;
            }
            case 5: {
                response = new WriteCoilResponse();
                break;
            }
            case 6: {
                response = new WriteSingleRegisterResponse();
                break;
            }
            case 15: {
                response = new WriteMultipleCoilsResponse();
                break;
            }
            case 16: {
                response = new WriteMultipleRegistersResponse();
                break;
            }
            case 7: {
                response = new ReadExceptionStatusResponse();
                break;
            }
            case 8: {
                response = new ReadSerialDiagnosticsResponse();
                break;
            }
            case 11: {
                response = new ReadCommEventCounterResponse();
                break;
            }
            case 12: {
                response = new ReadCommEventLogResponse();
                break;
            }
            case 17: {
                response = new ReportSlaveIDResponse();
                break;
            }
            case 20: {
                response = new ReadFileRecordResponse();
                break;
            }
            case 21: {
                response = new WriteFileRecordResponse();
                break;
            }
            case 22: {
                response = new MaskWriteRegisterResponse();
                break;
            }
            case 23: {
                response = new ReadWriteMultipleResponse();
                break;
            }
            case 24: {
                response = new ReadFIFOQueueResponse();
                break;
            }
            case 43: {
                response = new ReadMEIResponse();
                break;
            }
            default: {
                response = (functionCode & 0x80) != 0 ? new ExceptionResponse(functionCode) : new ExceptionResponse();
            }
        }
        return response;
    }

    protected void setMessage(byte[] msg) {
        try {
            this.readData(new DataInputStream(new ByteArrayInputStream(msg)));
        }
        catch (IOException ex) {
            logger.error("Problem setting response message - {}", (Object)ex.getMessage());
        }
    }

    public AuxiliaryMessageTypes getAuxiliaryType() {
        return this.auxiliaryType;
    }

    public void setAuxiliaryType(AuxiliaryMessageTypes auxiliaryType) {
        this.auxiliaryType = auxiliaryType;
    }

    public static enum AuxiliaryMessageTypes {
        NONE,
        UNIT_ID_MISSMATCH;

    }
}

