/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import net.wimpi.modbus.msg.ExceptionResponse;
import net.wimpi.modbus.msg.IllegalFunctionRequest;
import net.wimpi.modbus.msg.MaskWriteRegisterRequest;
import net.wimpi.modbus.msg.ModbusMessageImpl;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadCoilsRequest;
import net.wimpi.modbus.msg.ReadCommEventCounterRequest;
import net.wimpi.modbus.msg.ReadCommEventLogRequest;
import net.wimpi.modbus.msg.ReadExceptionStatusRequest;
import net.wimpi.modbus.msg.ReadFIFOQueueRequest;
import net.wimpi.modbus.msg.ReadFileRecordRequest;
import net.wimpi.modbus.msg.ReadInputDiscretesRequest;
import net.wimpi.modbus.msg.ReadInputRegistersRequest;
import net.wimpi.modbus.msg.ReadMEIRequest;
import net.wimpi.modbus.msg.ReadMultipleRegistersRequest;
import net.wimpi.modbus.msg.ReadSerialDiagnosticsRequest;
import net.wimpi.modbus.msg.ReadWriteMultipleRequest;
import net.wimpi.modbus.msg.ReportSlaveIDRequest;
import net.wimpi.modbus.msg.WriteCoilRequest;
import net.wimpi.modbus.msg.WriteFileRecordRequest;
import net.wimpi.modbus.msg.WriteMultipleCoilsRequest;
import net.wimpi.modbus.msg.WriteMultipleRegistersRequest;
import net.wimpi.modbus.msg.WriteSingleRegisterRequest;
import net.wimpi.modbus.net.AbstractModbusListener;

public abstract class ModbusRequest
extends ModbusMessageImpl {
    public static ModbusRequest createModbusRequest(int functionCode) {
        ModbusRequest request;
        switch (functionCode) {
            case 1: {
                request = new ReadCoilsRequest();
                break;
            }
            case 2: {
                request = new ReadInputDiscretesRequest();
                break;
            }
            case 3: {
                request = new ReadMultipleRegistersRequest();
                break;
            }
            case 4: {
                request = new ReadInputRegistersRequest();
                break;
            }
            case 5: {
                request = new WriteCoilRequest();
                break;
            }
            case 6: {
                request = new WriteSingleRegisterRequest();
                break;
            }
            case 15: {
                request = new WriteMultipleCoilsRequest();
                break;
            }
            case 16: {
                request = new WriteMultipleRegistersRequest();
                break;
            }
            case 7: {
                request = new ReadExceptionStatusRequest();
                break;
            }
            case 8: {
                request = new ReadSerialDiagnosticsRequest();
                break;
            }
            case 11: {
                request = new ReadCommEventCounterRequest();
                break;
            }
            case 12: {
                request = new ReadCommEventLogRequest();
                break;
            }
            case 17: {
                request = new ReportSlaveIDRequest();
                break;
            }
            case 20: {
                request = new ReadFileRecordRequest();
                break;
            }
            case 21: {
                request = new WriteFileRecordRequest();
                break;
            }
            case 22: {
                request = new MaskWriteRegisterRequest();
                break;
            }
            case 23: {
                request = new ReadWriteMultipleRequest();
                break;
            }
            case 24: {
                request = new ReadFIFOQueueRequest();
                break;
            }
            case 43: {
                request = new ReadMEIRequest();
                break;
            }
            default: {
                request = new IllegalFunctionRequest(functionCode);
            }
        }
        return request;
    }

    public abstract ModbusResponse getResponse();

    public abstract ModbusResponse createResponse(AbstractModbusListener var1);

    public ModbusResponse createExceptionResponse(int code) {
        return this.updateResponseWithHeader(new ExceptionResponse(this.getFunctionCode(), code), true);
    }

    ModbusResponse updateResponseWithHeader(ModbusResponse response) {
        return this.updateResponseWithHeader(response, false);
    }

    ModbusResponse updateResponseWithHeader(ModbusResponse response, boolean ignoreFunctionCode) {
        response.setHeadless(this.isHeadless());
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        } else {
            response.setHeadless();
        }
        response.setUnitID(this.getUnitID());
        if (!ignoreFunctionCode) {
            response.setFunctionCode(this.getFunctionCode());
        }
        return response;
    }
}

