/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.modbus.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.modbus.io.AbstractModbusTransport;
import net.wimpi.modbus.modbus.io.BytesInputStream;
import net.wimpi.modbus.modbus.io.BytesOutputStream;
import net.wimpi.modbus.modbus.io.ModbusTransaction;
import net.wimpi.modbus.modbus.io.ModbusUDPTransaction;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.net.AbstractUDPTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusUDPTransport
extends AbstractModbusTransport {
    private static final Logger logger = LoggerFactory.getLogger(ModbusUDPTransport.class);
    private AbstractUDPTerminal terminal;
    private final BytesOutputStream byteOutputStream = new BytesOutputStream(256);
    private final BytesInputStream byteInputStream = new BytesInputStream(256);

    public ModbusUDPTransport(AbstractUDPTerminal terminal) {
        this.terminal = terminal;
    }

    @Override
    public void setTimeout(int time) {
        super.setTimeout(time);
        if (this.terminal != null) {
            this.terminal.setTimeout(this.timeout);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public ModbusTransaction createTransaction() {
        ModbusUDPTransaction trans = new ModbusUDPTransaction();
        trans.setTerminal(this.terminal);
        return trans;
    }

    @Override
    public void writeResponse(ModbusResponse msg) throws ModbusIOException {
        this.writeMessage(msg);
    }

    @Override
    public void writeRequest(ModbusRequest msg) throws ModbusIOException {
        this.writeMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModbusRequest readRequest(AbstractModbusListener listener) throws ModbusIOException {
        try {
            ModbusRequest req;
            BytesInputStream bytesInputStream = this.byteInputStream;
            synchronized (bytesInputStream) {
                this.byteInputStream.reset(this.terminal.receiveMessage());
                this.byteInputStream.skip(7);
                int functionCode = this.byteInputStream.readUnsignedByte();
                this.byteInputStream.reset();
                req = ModbusRequest.createModbusRequest(functionCode);
                req.readFrom(this.byteInputStream);
            }
            return req;
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O exception - failed to read", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModbusResponse readResponse() throws ModbusIOException {
        try {
            ModbusResponse res;
            BytesInputStream bytesInputStream = this.byteInputStream;
            synchronized (bytesInputStream) {
                this.byteInputStream.reset(this.terminal.receiveMessage());
                this.byteInputStream.skip(7);
                int functionCode = this.byteInputStream.readUnsignedByte();
                this.byteInputStream.reset();
                res = ModbusResponse.createModbusResponse(functionCode);
                res.readFrom(this.byteInputStream);
            }
            return res;
        }
        catch (InterruptedIOException ioex) {
            throw new ModbusIOException("Socket was interrupted", ioex);
        }
        catch (Exception ex) {
            logger.debug("I/O exception while reading modbus response.", (Throwable)ex);
            throw new ModbusIOException("I/O exception - failed to read - %s", ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMessage(ModbusMessage msg) throws ModbusIOException {
        try {
            BytesOutputStream bytesOutputStream = this.byteOutputStream;
            synchronized (bytesOutputStream) {
                int len = msg.getOutputLength();
                this.byteOutputStream.reset();
                msg.writeTo(this.byteOutputStream);
                byte[] data = this.byteOutputStream.getBuffer();
                data = Arrays.copyOf(data, len);
                this.terminal.sendMessage(data);
            }
        }
        catch (Exception ex) {
            throw new ModbusIOException("I/O exception - failed to write", ex);
        }
    }
}

