/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.modbus.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.modbus.io.AbstractModbusTransport;
import net.wimpi.modbus.modbus.io.BytesInputStream;
import net.wimpi.modbus.modbus.io.BytesOutputStream;
import net.wimpi.modbus.modbus.io.ModbusTCPTransaction;
import net.wimpi.modbus.modbus.io.ModbusTransaction;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.net.TCPMasterConnection;
import net.wimpi.modbus.util.ModbusUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTCPTransport
extends AbstractModbusTransport {
    private static final Logger logger = LoggerFactory.getLogger(ModbusTCPTransport.class);
    private DataInputStream dataInputStream;
    private DataOutputStream dataOutputStream;
    private final BytesInputStream byteInputStream = new BytesInputStream(262);
    private final BytesOutputStream byteOutputStream = new BytesOutputStream(262);
    protected Socket socket = null;
    protected TCPMasterConnection master = null;
    private boolean headless = false;

    public ModbusTCPTransport() {
    }

    public ModbusTCPTransport(Socket socket) {
        try {
            this.setSocket(socket);
            socket.setSoTimeout(this.timeout);
        }
        catch (IOException ex) {
            logger.debug("ModbusTCPTransport::Socket invalid");
            throw new IllegalStateException("Socket invalid", ex);
        }
    }

    public void setSocket(Socket socket) throws IOException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        this.socket = socket;
        this.setTimeout(this.timeout);
        this.prepareStreams(socket);
    }

    public void setHeadless() {
        this.headless = true;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public void setMaster(TCPMasterConnection master) {
        this.master = master;
    }

    @Override
    public void setTimeout(int time) {
        super.setTimeout(time);
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(time);
            }
            catch (SocketException e) {
                logger.warn("Socket exception occurred while setting timeout to " + time, (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.dataInputStream.close();
        this.dataOutputStream.close();
        this.socket.close();
    }

    @Override
    public ModbusTransaction createTransaction() {
        if (this.master == null) {
            this.master = new TCPMasterConnection(this.socket.getInetAddress());
            this.master.setPort(this.socket.getPort());
            this.master.setModbusTransport(this);
        }
        return new ModbusTCPTransaction(this.master);
    }

    @Override
    public void writeResponse(ModbusResponse msg) throws ModbusIOException {
        this.writeMessage(msg, false);
    }

    @Override
    public void writeRequest(ModbusRequest msg) throws ModbusIOException {
        this.writeMessage(msg, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModbusRequest readRequest(AbstractModbusListener listener) throws ModbusIOException {
        try {
            ModbusRequest req;
            this.byteInputStream.reset();
            BytesInputStream bytesInputStream = this.byteInputStream;
            synchronized (bytesInputStream) {
                byte[] buffer = this.byteInputStream.getBuffer();
                if (!this.headless) {
                    this.dataInputStream.readFully(buffer, 0, 6);
                    int transaction = ModbusUtil.registerToShort(buffer, 0) & 0xFFFF;
                    short protocol = ModbusUtil.registerToShort(buffer, 2);
                    short count = ModbusUtil.registerToShort(buffer, 4);
                    this.dataInputStream.readFully(buffer, 6, count);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Read: {}", (Object)ModbusUtil.toHex(buffer, 0, count + 6));
                    }
                    this.byteInputStream.reset(buffer, 6 + count);
                    this.byteInputStream.skip(6);
                    byte unit = this.byteInputStream.readByte();
                    int functionCode = this.byteInputStream.readUnsignedByte();
                    this.byteInputStream.reset();
                    req = ModbusRequest.createModbusRequest(functionCode);
                    req.setUnitID(unit);
                    req.setHeadless(false);
                    req.setTransactionID(transaction);
                    req.setProtocolID(protocol);
                    req.setDataLength(count);
                    req.readFrom(this.byteInputStream);
                } else {
                    byte unit = this.dataInputStream.readByte();
                    byte function = this.dataInputStream.readByte();
                    req = ModbusRequest.createModbusRequest(function);
                    req.setUnitID(unit);
                    req.setHeadless(true);
                    req.readData(this.dataInputStream);
                    this.dataInputStream.readShort();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Read: {}", (Object)req.getHexMessage());
                    }
                }
            }
            return req;
        }
        catch (EOFException eoex) {
            throw new ModbusIOException("End of File", true);
        }
        catch (SocketTimeoutException x) {
            throw new ModbusIOException("Timeout reading request", x);
        }
        catch (SocketException sockex) {
            throw new ModbusIOException("Socket Exception", sockex);
        }
        catch (IOException ex) {
            throw new ModbusIOException("I/O exception - failed to read", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModbusResponse readResponse() throws ModbusIOException {
        try {
            ModbusResponse response;
            BytesInputStream bytesInputStream = this.byteInputStream;
            synchronized (bytesInputStream) {
                byte[] buffer = this.byteInputStream.getBuffer();
                logger.debug("Reading response...");
                if (!this.headless) {
                    this.dataInputStream.readFully(buffer, 0, 6);
                    int transaction = ModbusUtil.registerToShort(buffer, 0) & 0xFFFF;
                    short protocol = ModbusUtil.registerToShort(buffer, 2);
                    short count = ModbusUtil.registerToShort(buffer, 4);
                    this.dataInputStream.readFully(buffer, 6, count);
                    this.byteInputStream.reset(buffer, 6 + count);
                    this.byteInputStream.reset();
                    this.byteInputStream.skip(7);
                    int function = this.byteInputStream.readUnsignedByte();
                    response = ModbusResponse.createModbusResponse(function);
                    this.byteInputStream.reset();
                    response.readFrom(this.byteInputStream);
                    response.setTransactionID(transaction);
                    response.setProtocolID(protocol);
                } else {
                    byte unit = this.dataInputStream.readByte();
                    byte function = this.dataInputStream.readByte();
                    response = ModbusResponse.createModbusResponse(function);
                    response.setUnitID(unit);
                    response.setHeadless();
                    response.readData(this.dataInputStream);
                    this.dataInputStream.readShort();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully read: {}", (Object)response.getHexMessage());
            }
            return response;
        }
        catch (EOFException ex1) {
            throw new ModbusIOException("Premature end of stream (Message truncated) - %s", ex1.getMessage());
        }
        catch (SocketTimeoutException ex2) {
            throw new ModbusIOException("Socket timeout reading response - %s", ex2.getMessage());
        }
        catch (Exception ex3) {
            throw new ModbusIOException("General exception - failed to read - %s", ex3.getMessage());
        }
    }

    private void prepareStreams(Socket socket) throws IOException {
        try {
            if (this.dataInputStream != null) {
                this.dataInputStream.close();
            }
            if (this.dataOutputStream != null) {
                this.dataOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dataInputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.dataOutputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    void writeMessage(ModbusMessage msg, boolean useRtuOverTcp) throws ModbusIOException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending: {}", (Object)msg.getHexMessage());
            }
            byte[] message = msg.getMessage();
            this.byteOutputStream.reset();
            if (!this.headless) {
                this.byteOutputStream.writeShort(msg.getTransactionID());
                this.byteOutputStream.writeShort(msg.getProtocolID());
                this.byteOutputStream.writeShort((message != null ? message.length : 0) + 2);
            }
            this.byteOutputStream.writeByte(msg.getUnitID());
            this.byteOutputStream.writeByte(msg.getFunctionCode());
            if (message != null && message.length > 0) {
                this.byteOutputStream.write(message);
            }
            if (useRtuOverTcp) {
                int len = this.byteOutputStream.size();
                int[] crc = ModbusUtil.calculateCRC(this.byteOutputStream.getBuffer(), 0, len);
                this.byteOutputStream.writeByte(crc[0]);
                this.byteOutputStream.writeByte(crc[1]);
            }
            this.dataOutputStream.write(this.byteOutputStream.toByteArray());
            this.dataOutputStream.flush();
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully sent: {}", (Object)ModbusUtil.toHex(this.byteOutputStream.toByteArray()));
            }
        }
        catch (SocketException ex1) {
            if (this.master != null && !this.master.isConnected()) {
                try {
                    this.master.connect(useRtuOverTcp);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new ModbusIOException("I/O socket exception - failed to write - %s", ex1.getMessage());
        }
        catch (Exception ex2) {
            throw new ModbusIOException("General exception - failed to write - %s", ex2.getMessage());
        }
    }
}

