/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.modbus.io;

import java.io.IOException;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.modbus.io.BytesInputStream;
import net.wimpi.modbus.modbus.io.BytesOutputStream;
import net.wimpi.modbus.modbus.io.ModbusSerialTransport;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.AbstractModbusListener;
import net.wimpi.modbus.util.ModbusUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusASCIITransport
extends ModbusSerialTransport {
    private static final Logger logger = LoggerFactory.getLogger(ModbusASCIITransport.class);
    private static final String I_O_EXCEPTION_SERIAL_PORT_TIMEOUT = "I/O exception - Serial port timeout";
    private final byte[] inBuffer = new byte[256];
    private final BytesInputStream byteInputStream = new BytesInputStream(this.inBuffer);
    private final BytesOutputStream byteInputOutputStream = new BytesOutputStream(this.inBuffer);
    private final BytesOutputStream byteOutputStream = new BytesOutputStream(256);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeMessageOut(ModbusMessage msg) throws ModbusIOException {
        try {
            BytesOutputStream bytesOutputStream = this.byteOutputStream;
            synchronized (bytesOutputStream) {
                msg.setHeadless();
                msg.writeTo(this.byteOutputStream);
                byte[] buf = this.byteOutputStream.getBuffer();
                int len = this.byteOutputStream.size();
                this.writeAsciiByte(1000);
                this.writeAsciiBytes(buf, len);
                if (logger.isDebugEnabled()) {
                    logger.debug("Writing: {}", (Object)ModbusUtil.toHex(buf, 0, len));
                }
                this.writeAsciiByte(ModbusASCIITransport.calculateLRC(buf, 0, len));
                this.writeAsciiByte(2000);
                this.byteOutputStream.reset();
                if (this.echo) {
                    this.readEcho(len + 3);
                }
            }
        }
        catch (IOException ex) {
            throw new ModbusIOException("I/O failed to write");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public ModbusRequest readRequestIn(AbstractModbusListener listener) throws ModbusIOException {
        boolean done = false;
        ModbusRequest request = null;
        try {
            while (true) {
                block10: {
                    if (this.readAsciiByte() != 1000) {
                        continue;
                    }
                    byte[] byArray = this.inBuffer;
                    // MONITORENTER : this.inBuffer
                    this.byteInputOutputStream.reset();
                    while (true) {
                        int in;
                        if ((in = this.readAsciiByte()) == 2000) {
                            if (this.inBuffer[this.byteInputOutputStream.size() - 1] == ModbusASCIITransport.calculateLRC(this.inBuffer, 0, this.byteInputOutputStream.size(), 1)) break;
                            // MONITOREXIT : byArray
                            break block10;
                        }
                        if (in == -1) {
                            throw new IOException(I_O_EXCEPTION_SERIAL_PORT_TIMEOUT);
                        }
                        this.byteInputOutputStream.writeByte(in);
                    }
                    this.byteInputStream.reset(this.inBuffer, this.byteInputOutputStream.size());
                    this.byteInputStream.readUnsignedByte();
                    int functionCode = this.byteInputStream.readUnsignedByte();
                    request = ModbusRequest.createModbusRequest(functionCode);
                    request.setHeadless();
                    this.byteInputStream.reset(this.inBuffer, this.byteInputOutputStream.size());
                    request.readFrom(this.byteInputStream);
                    // MONITOREXIT : byArray
                    done = true;
                }
                if (done) return request;
            }
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage());
            throw new ModbusIOException("I/O exception - failed to read");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected ModbusResponse readResponseIn() throws ModbusIOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int calculateLRC(byte[] data, int off, int length) {
        return ModbusASCIITransport.calculateLRC(data, off, length, 0);
    }

    private static byte calculateLRC(byte[] data, int off, int length, int tailskip) {
        int lrc = 0;
        int i = off;
        while (i < length - tailskip) {
            lrc += data[i] & 0xFF;
            ++i;
        }
        return (byte)(-lrc & 0xFF);
    }
}

