/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.facade;

import net.wimpi.modbus.facade.AbstractModbusMaster;
import net.wimpi.modbus.modbus.io.AbstractModbusTransport;
import net.wimpi.modbus.modbus.io.ModbusSerialTransaction;
import net.wimpi.modbus.net.AbstractSerialConnection;
import net.wimpi.modbus.net.SerialConnection;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.procimg.SimpleRegister;
import net.wimpi.modbus.util.ModbusUtil;
import net.wimpi.modbus.util.SerialParameters;

public class ModbusSerialMaster
extends AbstractModbusMaster {
    private AbstractSerialConnection connection;
    private int transDelay;

    public ModbusSerialMaster(SerialParameters param) {
        this(param, 3000, 0);
    }

    public ModbusSerialMaster(SerialParameters param, int timeout) {
        this(param, timeout, 0);
    }

    public ModbusSerialMaster(SerialParameters param, int timeout, int transDelay) {
        try {
            this.transDelay = transDelay > -1 ? transDelay : 0;
            this.connection = new SerialConnection(param);
            this.connection.setTimeout(timeout);
            this.timeout = timeout;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public AbstractSerialConnection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized void connect() throws Exception {
        if (this.connection != null && !this.connection.isOpen()) {
            this.connection.open();
            this.transaction = this.connection.getModbusTransport().createTransaction();
            ((ModbusSerialTransaction)this.transaction).setTransDelayMS(this.transDelay);
            this.setTransaction(this.transaction);
        }
    }

    public void setTransDelayMS(int millseconds) {
        if (this.transaction != null) {
            ((ModbusSerialTransaction)this.transaction).setTransDelayMS(millseconds);
        }
    }

    public int getCurrentTryTimes() {
        if ((ModbusSerialTransaction)this.transaction != null) {
            return ((ModbusSerialTransaction)this.transaction).getCurrentTryTimes();
        }
        return -1;
    }

    @Override
    public synchronized void disconnect() {
        if (this.connection != null) {
            this.connection.close();
            this.transaction = null;
            this.setTransaction(null);
        }
    }

    public int getTransDelay() {
        return this.transDelay;
    }

    public void setTransDelay(int transDelay) {
        this.transDelay = transDelay;
    }

    @Override
    public synchronized void setTimeout(int timeout) {
        super.setTimeout(timeout);
        if (this.connection != null) {
            this.connection.setTimeout(timeout);
        }
    }

    @Override
    public AbstractModbusTransport getTransport() {
        return this.connection == null ? null : this.connection.getModbusTransport();
    }

    public static void main(String[] args) {
        SerialParameters paras = new SerialParameters("COM3", 19200, 0, 0, 8, 1, 0, false);
        paras.setEncoding("rtu");
        ModbusSerialMaster master = new ModbusSerialMaster(paras, 300);
        try {
            master.connect();
            byte[] bytes = ModbusUtil.intToRegisters(256);
            SimpleRegister reg = new SimpleRegister(bytes[2], bytes[3]);
            master.writeMultipleRegisters(1, 26, new Register[]{reg});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

