/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.jvm;

import com.zerog.util.jvm.ValidatorUtils;
import java.util.StringTokenizer;

public class Version {
    private String release;
    private String major;
    private String minor;
    private String patch;

    public String getMajor() {
        return this.major;
    }

    public void setMajor(String string) {
        this.major = string;
    }

    public String getMinor() {
        return this.minor;
    }

    public void setMinor(String string) {
        this.minor = string;
    }

    public String getPatch() {
        return this.patch;
    }

    public void setPatch(String string) {
        this.patch = string;
    }

    public String getRelease() {
        return this.release;
    }

    public void setRelease(String string) {
        this.release = string;
    }

    public String toString() {
        String string = this.release + "." + this.major;
        if (!ValidatorUtils.isEmpty(this.minor)) {
            string = string + "." + this.minor;
        }
        if (!ValidatorUtils.isEmpty(this.patch)) {
            string = string + "_" + this.patch;
        }
        return string;
    }

    private String toStringWithoutWildcards() {
        return this.removeNonDigitEndingChars(this.toString());
    }

    private String removeNonDigitEndingChars(String string) {
        while (string != null && string.length() > 0 && !Character.isDigit(string.charAt(string.length() - 1))) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String subVersion(boolean bl, boolean bl2) {
        String string = this.release + "." + this.major;
        if (!ValidatorUtils.isEmpty(this.minor) && bl) {
            string = string + "." + this.minor;
        }
        if (!ValidatorUtils.isEmpty(this.patch) && bl2) {
            string = string + "_" + this.patch;
        }
        return string;
    }

    public boolean match(String string) {
        Version version = Version.parse(string);
        if (this.toString().endsWith("+")) {
            return version.toNumber() >= this.toNumber();
        }
        if (this.toString().endsWith("*")) {
            String string2 = this.removeNonDigitEndingChars(this.getMinor());
            boolean bl = !ValidatorUtils.isEmpty(string2);
            String string3 = this.removeNonDigitEndingChars(this.getPatch());
            boolean bl2 = !ValidatorUtils.isEmpty(string3);
            return version.subVersion(bl, bl2).equals(this.toStringWithoutWildcards());
        }
        return version.toNumber() == this.toNumber();
    }

    public int toNumber() {
        int n = 0;
        Version version = Version.parse(this.toStringWithoutWildcards());
        if (!ValidatorUtils.isEmpty(version.getRelease())) {
            n += Integer.parseInt(version.getRelease()) * 1000000;
        }
        if (!ValidatorUtils.isEmpty(version.getMajor())) {
            n += Integer.parseInt(version.getMajor()) * 10000;
        }
        if (!ValidatorUtils.isEmpty(version.getMinor())) {
            n += Integer.parseInt(version.getMinor()) * 100;
        }
        if (!ValidatorUtils.isEmpty(version.getPatch())) {
            n += Integer.parseInt(version.getPatch());
        }
        return n;
    }

    public static Version parse(String string) {
        string = string.trim();
        Version version = new Version();
        char c = string.charAt(string.length() - 1);
        while (!Character.isDigit(c) && c != '+' && c != '*') {
            string = string.substring(0, string.length() - 1);
            c = string.charAt(string.length() - 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (ValidatorUtils.isEmpty(version.getRelease())) {
                version.setRelease(string2);
                continue;
            }
            if (ValidatorUtils.isEmpty(version.getMajor())) {
                version.setMajor(string2);
                continue;
            }
            if (!ValidatorUtils.isEmpty(version.getMinor())) continue;
            int n = string2.indexOf("_");
            if (n > -1) {
                version.setMinor(string2.substring(0, n));
                version.setPatch(string2.substring(n + 1, string2.length()));
                continue;
            }
            version.setMinor(string2);
        }
        return version;
    }

    public static boolean isValid(String string) {
        if (ValidatorUtils.isEmpty(string)) {
            return false;
        }
        int n = ValidatorUtils.getCharCount(string, '.');
        int c = ValidatorUtils.getCharCount(string, '_');
        if (n < 1 || n > 2 || c > 1) {
            return false;
        }
        string = string.trim();
        for (n = 0; n < string.length(); ++n) {
            char c2 = string.charAt(n);
            if (Character.isDigit(c2) || c2 == '.' && n > 0 && n < string.length() - 1 && string.charAt(n - 1) != '.' || c2 == '*' && n > 0 && n == string.length() - 1 || c2 == '+' && n > 0 && n == string.length() - 1 || c2 == '_' && n > 0 && string.indexOf(46, n + 1) < 0 && ValidatorUtils.getCharCount(string, '.') == 2 && n < string.length() - 1 && Character.isDigit(string.charAt(n - 1))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.major == null ? 0 : this.major.hashCode());
        n2 = 31 * n2 + (this.minor == null ? 0 : this.minor.hashCode());
        n2 = 31 * n2 + (this.patch == null ? 0 : this.patch.hashCode());
        n2 = 31 * n2 + (this.release == null ? 0 : this.release.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Version version = (Version)object;
        if (this.major == null ? version.major != null : !this.major.equals(version.major)) {
            return false;
        }
        if (this.minor == null ? version.minor != null : !this.minor.equals(version.minor)) {
            return false;
        }
        if (this.patch == null ? version.patch != null : !this.patch.equals(version.patch)) {
            return false;
        }
        return !(this.release == null ? version.release != null : !this.release.equals(version.release));
    }
}

