/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.jvm;

import com.zerog.util.jvm.Filter;
import com.zerog.util.jvm.Introspector;
import com.zerog.util.jvm.RunningVMIntrospector;
import com.zerog.util.jvm.ValidatorTimeoutException;
import com.zerog.util.jvm.ValidatorUtils;
import com.zerog.util.jvm.Version;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Validator {
    private static final String FILTER_LIST_DELIMITER = " ";
    private static final String VM_VALIDATOR_CLASS = "com.zerog.util.jvm.Validator";
    private static final int VENDOR_CHECK = 1;
    private static final int FILTER_CHECK = 2;
    private static final int JVM_TIMEOUT = 15000;
    private static Hashtable vendorMappings = new Hashtable();
    private Introspector jvmIntrospector;
    private Vector filters;

    public Validator() {
        this(new Vector());
    }

    public Validator(Vector vector) {
        this(new RunningVMIntrospector(), vector);
    }

    public Validator(Introspector introspector, Vector vector) {
        this.jvmIntrospector = introspector;
        this.filters = vector;
    }

    public Vector validate(Collection collection) {
        return this.validateVM(collection, this.filters);
    }

    public synchronized Vector validateVM(Collection collection, Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.validateVM(string, vector)) continue;
            vector2.add(string);
        }
        return vector2;
    }

    public boolean validateVM(String string) {
        return this.validateVM(string, this.filters);
    }

    public synchronized boolean validateVM(String string, Vector vector) {
        boolean bl = false;
        File file = new File(string);
        if (file.exists()) {
            try {
                String string2 = new File(string).getAbsolutePath();
                String string3 = System.getProperty("java.class.path");
                Vector<String> vector2 = new Vector<String>();
                vector2.add(string2);
                vector2.add("-cp");
                vector2.add(string3);
                vector2.add(VM_VALIDATOR_CLASS);
                vector2.add(Integer.toString(2));
                vector2.add(string2);
                vector2.addAll(vector);
                Process process = Runtime.getRuntime().exec(vector2.toArray(new String[0]));
                Thread thread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                thread.start();
                if (thread.isAlive()) {
                    thread.join(15000L);
                    if (thread.isAlive()) {
                        thread.interrupt();
                        throw new ValidatorTimeoutException();
                    }
                }
                bl = process.exitValue() == 0;
            }
            catch (IOException iOException) {
                bl = false;
            }
            catch (InterruptedException interruptedException) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean checkFilter(String string, Filter filter) {
        if (filter != null) {
            if (!ValidatorUtils.isEmpty(filter.getVendor()) && !this.checkVendor(filter.getVendor())) {
                return false;
            }
            if (!ValidatorUtils.isEmpty(filter.getType()) && !this.checkType(string, filter.getType())) {
                return false;
            }
            if (filter.getVersion() != null && !this.checkVersion(filter.getVersion())) {
                return false;
            }
        }
        return true;
    }

    public boolean checkVendor(String string) {
        String string2 = this.jvmIntrospector.getVendor();
        if (string2.toLowerCase().startsWith(string.toLowerCase())) {
            return true;
        }
        if (vendorMappings.containsKey(string.trim().toUpperCase())) {
            string = (String)vendorMappings.get(string.toUpperCase());
            return this.checkVendor(string);
        }
        return false;
    }

    public boolean checkType(String string, String string2) {
        if (string2.equalsIgnoreCase("ALL")) {
            return true;
        }
        return string2.equalsIgnoreCase(this.jvmIntrospector.getType(string));
    }

    public boolean checkVersion(Version version) {
        return version.match(this.jvmIntrospector.getVersion());
    }

    public static Hashtable getVendorMappings() {
        return vendorMappings;
    }

    public static void setVendorMappings(Hashtable hashtable) {
        vendorMappings = hashtable;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.exit(1);
        }
        Validator validator = new Validator();
        int n = Integer.parseInt(stringArray[0]);
        switch (n) {
            case 1: {
                if (stringArray.length < 2) {
                    System.exit(1);
                    break;
                }
                System.exit(validator.checkVendor(stringArray[1]) ? 0 : 1);
                break;
            }
            case 2: {
                if (stringArray.length < 3) {
                    System.exit(1);
                    break;
                }
                for (int i = 2; i < stringArray.length; ++i) {
                    boolean bl = false;
                    String[] stringArray2 = stringArray[i].split(FILTER_LIST_DELIMITER);
                    for (int j = 0; j < stringArray2.length; ++j) {
                        Filter filter = Filter.parse(stringArray2[j]);
                        if (filter == null || !validator.checkFilter(stringArray[1], filter)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    System.exit(1);
                }
                System.exit(0);
                break;
            }
        }
        System.exit(1);
    }

    static {
        vendorMappings.put("HP", "Hewlett-Packard");
    }
}

