/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util;

import com.zerog.common.io.NullInputStream;
import com.zerog.common.io.NullOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class DebugOutputConfig {
    public static final InputStream originalSTDIN = System.in;
    public static final PrintStream originalSTDOUT = System.out;
    public static final PrintStream originalSTDERR = System.err;
    public static final String CONSOLE_REDIRECT = "console";
    private static final String VAR_DELIMITER = "$";
    private static final String JAVA_PROP_PREFIX = "prop.";
    private static final String SYS_PROP_EXACTCASE_PREFIX = "lax.nl.env.exact_case.";
    private static final String userName = System.getProperty("user.name");
    private static final String osVersion = System.getProperty("os.version", "");
    private static final String osName = System.getProperty("os.name").toLowerCase();
    private static final boolean isMacOSX = osName.indexOf("mac") != -1 && osName.indexOf("x") != -1;
    private static final String MAC_LOG_FILE = "/var/tmp/console.log";
    private static final String MAC_103_LOG_FILE = "/Library/Logs/Console/" + userName + "/console.log";
    private static final String[] SUPPORTED_PLATFORMS = new String[]{"unix", "irix", "netbsd", "freebsd", "bsdi", "bsd", "unixware", "aix", "dg/ux", "dgux", "osf1", "linux", "machten", "nextstep", "rhapsody", "mac os x", "hp-ux", "hpux", "sunos", "solaris", "windows"};

    public static void configStdInStdOutStdErrOnSupportedPlatforms() {
        String string = System.getProperty("lax.stdin.redirect", "").trim();
        String string2 = System.getProperty("lax.stdout.redirect", "").trim();
        String string3 = System.getProperty("lax.stderr.redirect", "").trim();
        boolean bl = false;
        boolean bl2 = false;
        if (isMacOSX && string2.equalsIgnoreCase(CONSOLE_REDIRECT)) {
            if (osVersion.startsWith("10.3")) {
                System.setProperty("lax.stdout.redirect", MAC_103_LOG_FILE);
            } else if (!osVersion.startsWith("10.4")) {
                System.setProperty("lax.stdout.redirect", MAC_LOG_FILE);
            }
            bl = true;
        }
        if (isMacOSX && string3.equalsIgnoreCase(CONSOLE_REDIRECT)) {
            if (osVersion.startsWith("10.3")) {
                System.setProperty("lax.stderr.redirect", MAC_103_LOG_FILE);
            } else if (!osVersion.startsWith("10.4")) {
                System.setProperty("lax.stderr.redirect", MAC_LOG_FILE);
            }
            bl2 = true;
        }
        for (int i = 0; i < SUPPORTED_PLATFORMS.length; ++i) {
            if (osName.indexOf(SUPPORTED_PLATFORMS[i]) == -1) continue;
            DebugOutputConfig.configStdInStdOutStdErr(string, string2, bl, string3, bl2);
            break;
        }
    }

    public static void configStdInStdOutStdErr(String string, String string2, boolean bl, String string3, boolean bl2) {
        String string4;
        File file;
        if (string != null && !string.equals("")) {
            if (!string.toLowerCase().equals(CONSOLE_REDIRECT)) {
                try {
                    System.setIn(new FileInputStream(string));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ZeroGb.g("Error reading stdin from file: " + string);
                }
            }
        } else {
            System.setIn(new NullInputStream());
        }
        if (string2 != null && !string2.equals("")) {
            if (!string2.toLowerCase().equals(CONSOLE_REDIRECT)) {
                string2 = DebugOutputConfig.substituteVariables(string2);
                try {
                    file = new File(string2).getParentFile();
                    if (file != null) {
                        file.mkdirs();
                    }
                    System.setOut(DebugOutputConfig.createPrintStream(string2, bl));
                }
                catch (Exception exception) {
                    try {
                        string4 = File.createTempFile("lax-", "-out.txt").getAbsolutePath();
                        ZeroGb.g("Error redirecting stdout to '" + string2 + "'. Output will be placed in file: " + string4);
                        System.setOut(DebugOutputConfig.createPrintStream(string4, false));
                    }
                    catch (IOException iOException) {
                        ZeroGb.c("Unable to create stdout output file.", iOException);
                    }
                }
            }
        } else {
            System.setOut(new PrintStream(new NullOutputStream()));
        }
        if (string3 != null && !string3.equals("")) {
            if (!string3.toLowerCase().equals(CONSOLE_REDIRECT)) {
                if (string3.equals(string2)) {
                    System.setErr(System.out);
                } else {
                    string3 = DebugOutputConfig.substituteVariables(string3);
                    try {
                        file = new File(string3).getParentFile();
                        if (file != null) {
                            file.mkdirs();
                        }
                        System.setErr(DebugOutputConfig.createPrintStream(string3, bl2));
                    }
                    catch (Exception exception) {
                        try {
                            string4 = File.createTempFile("lax-", "-err.txt").getAbsolutePath();
                            ZeroGb.g("Error redirecting stderr to '" + string3 + "'. Output will be placed in file: " + string4);
                            System.setErr(DebugOutputConfig.createPrintStream(string4, false));
                        }
                        catch (IOException iOException) {
                            ZeroGb.c("Unable to create stderr output file.", iOException);
                        }
                    }
                }
            }
        } else {
            System.setErr(new PrintStream(new NullOutputStream()));
        }
    }

    private static PrintStream createPrintStream(String string, boolean bl) throws FileNotFoundException {
        return new PrintStream(new FileOutputStream(string, bl));
    }

    public static String substituteVariables(String string) {
        String string2 = "";
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(VAR_DELIMITER, n)) > -1) {
            string2 = string2 + string.substring(n, n2);
            int n3 = string.indexOf(VAR_DELIMITER, n2 + 1);
            if (n3 > -1) {
                String string3 = string.substring(n2 + 1, n3);
                if (!string3.trim().equals("")) {
                    string2 = string2 + DebugOutputConfig.getVariable(string3);
                }
                n = n3 + 1;
                continue;
            }
            string2 = string2 + VAR_DELIMITER;
            n = n2 + 1;
        }
        string2 = string2 + string.substring(n);
        return string2;
    }

    public static String getVariable(String string) {
        if (string.equals("\\") || string.equals("/")) {
            return System.getProperty("file.separator", "/");
        }
        if (string.toLowerCase().startsWith(JAVA_PROP_PREFIX)) {
            return System.getProperty(string.toLowerCase().substring(JAVA_PROP_PREFIX.length()), "");
        }
        if (string.toLowerCase().startsWith(SYS_PROP_EXACTCASE_PREFIX)) {
            return System.getProperty(string, "");
        }
        return System.getProperty(string.toLowerCase(), "");
    }
}

