/*
 * Decompiled with CFR 0.152.
 */
package expect4j;

import expect4j.BlockingConsumer;
import expect4j.Closure;
import expect4j.Consumer;
import expect4j.ExpectState;
import expect4j.IOPair;
import expect4j.StreamPair;
import expect4j.matches.EofMatch;
import expect4j.matches.GlobMatch;
import expect4j.matches.Match;
import expect4j.matches.PatternPair;
import expect4j.matches.TimeoutMatch;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;

public class Expect4j {
    public static final Logger log = Logger.getLogger((class$expect4j$Expect4j == null ? (class$expect4j$Expect4j = Expect4j.class$("expect4j.Expect4j")) : class$expect4j$Expect4j).getName());
    IOPair pair;
    Consumer consumer;
    Thread consumerThread;
    Perl5Matcher matcher = new Perl5Matcher();
    PatternMatcherInput input;
    static final int STATE_UNINIT = 1;
    static final int STATE_INITIALIZED = 2;
    static final int STATE_EXPECTING = 3;
    static final int STATE_EXPECTED = 4;
    int mode = 1;
    public static final int RET_TRIED_ONCE = -4;
    public static final int RET_EOF = -3;
    public static final int RET_TIMEOUT = -2;
    public static final int RET_UNKNOWN = -1;
    private ExpectState g_state = null;
    public static final long TIMEOUT_NOTSET = -2L;
    public static final long TIMEOUT_FOREVER = -1L;
    public static final long TIMEOUT_NEVER = 0L;
    public static final long TIMEOUT_DEFAULT = 10000L;
    long defaultTimeout = 10000L;
    static /* synthetic */ Class class$expect4j$Expect4j;

    public Expect4j(IOPair pair) {
        this.matcher.setMultiline(true);
        this.input = new PatternMatcherInput("");
        this.pair = pair;
        this.consumer = new BlockingConsumer(pair);
        this.consumerThread = new Thread(this.consumer);
        this.consumerThread.setDaemon(true);
        this.consumerThread.start();
        this.mode = 2;
    }

    public Expect4j(Socket socket) throws Exception {
        this(socket.getInputStream(), socket.getOutputStream());
    }

    public Expect4j(InputStream is, OutputStream os) throws Exception {
        this(new StreamPair(is, os));
    }

    public void send(String str) throws IOException {
        log.fine("Sending from expect: " + str);
        this.consumer.send(str);
    }

    public int expect(String pattern) throws MalformedPatternException, Exception {
        return this.expect(pattern, null);
    }

    public int expect(String pattern, Closure single) throws MalformedPatternException, Exception {
        GlobMatch match = new GlobMatch(pattern, single);
        ArrayList<GlobMatch> list = new ArrayList<GlobMatch>();
        list.add(match);
        return this.expect(list);
    }

    public int expect(Match[] args) throws MalformedPatternException, Exception {
        ArrayList<Match> pairs = new ArrayList<Match>();
        for (int i = 0; i < args.length; ++i) {
            Match match = args[i];
            pairs.add(match);
        }
        return this.expect(pairs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int expect(List pairs) throws Exception {
        Object matchedText = null;
        EofMatch eofMatch = null;
        TimeoutMatch timeoutMatch = null;
        ArrayList patternMatches = new ArrayList();
        Iterator iter = pairs.iterator();
        while (iter.hasNext()) {
            Object match = iter.next();
            if (!(match instanceof Match)) {
                log.warning("Passed in a non-Match");
                continue;
            }
            if (match instanceof PatternPair) {
                patternMatches.add(match);
                continue;
            }
            if (match instanceof TimeoutMatch) {
                timeoutMatch = (TimeoutMatch)match;
                continue;
            }
            if (!(match instanceof EofMatch)) continue;
            eofMatch = (EofMatch)match;
        }
        long timeout = timeoutMatch != null && timeoutMatch.getTimeout() != -2L ? timeoutMatch.getTimeout() : this.defaultTimeout;
        long startTime = System.currentTimeMillis();
        long endTime = startTime + timeout;
        boolean foundTimeout = false;
        boolean foundEof = false;
        int index = -1;
        this.g_state = null;
        String toMatch = null;
        while (true) {
            if (timeout != -1L && System.currentTimeMillis() >= endTime) {
                log.fine("Timeout " + endTime + " when it is " + System.currentTimeMillis());
                foundTimeout = true;
                break;
            }
            Consumer consumer = this.consumer;
            synchronized (consumer) {
                toMatch = this.consumer.pause();
                log.finest("Size of toMatch: " + toMatch.length());
                foundEof = this.consumer.foundEOF();
                this.input.setInput(toMatch);
                log.finer("Finding first match using >>>" + this.printBuffer() + "<<<");
                boolean foundMatch = false;
                try {
                    foundMatch = this.runFirstMatch(patternMatches);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "In Closure", e);
                    this.consumer.resume();
                    throw e;
                }
                if (foundMatch) {
                    int matchedWhere = this.g_state.getMatchedWhere();
                    int matchedLength = this.g_state.getMatch().length();
                    log.fine("Matched @ " + matchedWhere + " with a length of " + matchedLength);
                    this.consumer.resume(matchedWhere + matchedLength);
                    PatternPair pair = (PatternPair)patternMatches.get(this.g_state.getPairIndex());
                    log.finer("Pair found " + pair.getPattern().getPattern());
                    index = pairs.indexOf(pair);
                    log.finer("Index found " + index);
                    if (!this.g_state.shouldContinue()) {
                        log.fine("NOT Continuing");
                        break;
                    }
                    log.fine("Continuing");
                    if (this.g_state.shouldResetTimer()) {
                        endTime = System.currentTimeMillis() + timeout;
                    }
                    continue;
                }
                log.fine("Nothing found, resuming consumer");
                this.consumer.resume();
                if (timeout == 0L) {
                    index = -4;
                    break;
                }
                if (foundEof) {
                    log.fine("Found EOF");
                    break;
                }
                if (timeout == -1L) {
                    this.consumer.waitForBuffer(-1L);
                } else {
                    long singleTimeout = endTime - System.currentTimeMillis();
                    log.fine("singleTimeout: " + singleTimeout);
                    if (timeout != -1L && singleTimeout <= 0L) {
                        continue;
                    }
                    log.fine("Waiting for more input");
                    this.consumer.waitForBuffer(singleTimeout);
                }
            }
        }
        log.fine("Leaving main while loop");
        Match lastmile = null;
        String lastmileBuffer = null;
        if (foundTimeout) {
            log.finer("Dealing with Timeout");
            if (timeoutMatch == null) {
                index = -2;
            } else {
                lastmile = timeoutMatch;
            }
        }
        if (foundEof) {
            log.finer("Dealing with EOF " + eofMatch);
            if (eofMatch != null) {
                lastmileBuffer = toMatch;
                lastmile = eofMatch;
            } else if (index == -1) {
                index = -3;
            }
        }
        if (lastmile != null) {
            log.fine("Running last mile");
            Closure closure = lastmile.getClosure();
            index = pairs.indexOf(lastmile);
            ExpectState state = this.prepareClosure(index, lastmileBuffer);
            try {
                if (closure != null) {
                    closure.run(state);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "In Last Mile Closure", e);
                log.finer("Closure body: " + closure.toString());
                throw e;
            }
            finally {
                this.g_state = state;
            }
        }
        return index;
    }

    protected String printBuffer() {
        String javaStr = new String(this.input.getBuffer());
        javaStr = javaStr.replaceAll("\\r", "\\\\r");
        javaStr = javaStr.replaceAll("\\n", "\\\\n");
        return javaStr;
    }

    protected ExpectState prepareClosure(int pairIndex, String buffer) {
        Map prevMap = null;
        if (this.g_state != null) {
            prevMap = this.g_state.getVars();
        }
        ExpectState state = new ExpectState(pairIndex, buffer, prevMap);
        return state;
    }

    protected ExpectState prepareClosure(int pairIndex, MatchResult result) {
        Map prevMap = null;
        if (this.g_state != null) {
            prevMap = this.g_state.getVars();
        }
        int matchedWhere = result.beginOffset(0);
        String matchedText = result.toString();
        char[] chBuffer = this.input.getBuffer();
        String copyBuffer = new String(chBuffer, 0, result.endOffset(0));
        ArrayList<String> groups = new ArrayList<String>();
        for (int j = 1; j <= result.groups(); ++j) {
            String group = result.group(j);
            groups.add(group);
        }
        ExpectState state = new ExpectState(copyBuffer.toString(), matchedWhere, matchedText, pairIndex, groups, prevMap);
        return state;
    }

    protected boolean runFirstMatch(List pairs) throws Exception {
        MatchResult firstResult = null;
        PatternPair firstPair = null;
        int pairIndex = -1;
        ListIterator iter = pairs.listIterator();
        while (iter.hasNext()) {
            PatternPair pair = (PatternPair)iter.next();
            Pattern pattern = pair.getPattern();
            this.input.setCurrentOffset(this.input.getBeginOffset());
            if (!this.matcher.contains(this.input, pattern)) continue;
            MatchResult result = this.matcher.getMatch();
            if (firstResult != null && result.beginOffset(0) >= firstResult.beginOffset(0)) continue;
            firstResult = result;
            firstPair = pair;
            pairIndex = iter.previousIndex();
        }
        if (firstResult == null) {
            return false;
        }
        log.fine("Using a result for " + firstPair.getPattern().getPattern());
        ExpectState state = this.prepareClosure(pairIndex, firstResult);
        Closure closure = firstPair.getClosure();
        try {
            if (closure != null) {
                closure.run(state);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.g_state = state;
        }
        return true;
    }

    public ExpectState getLastState() {
        return this.g_state != null ? this.g_state : new ExpectState();
    }

    public void setDefaultTimeout(long timeout) {
        log.finer("Setting Default Timeout to " + timeout);
        this.defaultTimeout = timeout;
    }

    protected TimeoutMatch findTimeout(Match[] matches) {
        TimeoutMatch ourTimeout = null;
        for (int i = 0; i < matches.length; ++i) {
            if (!(matches[i] instanceof TimeoutMatch)) continue;
            ourTimeout = (TimeoutMatch)matches[i];
        }
        return ourTimeout;
    }

    protected EofMatch findEof(Match[] matches) {
        EofMatch ourEof = null;
        for (int i = 0; i < matches.length; ++i) {
            if (!(matches[i] instanceof EofMatch)) continue;
            ourEof = (EofMatch)matches[i];
        }
        if (ourEof == null) {
            ourEof = new EofMatch();
        }
        return ourEof;
    }

    public void close() {
        log.fine("Closing");
        this.consumer.stop();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

