/*
 * Decompiled with CFR 0.152.
 */
package expect4j;

import expect4j.ConsumerImpl;
import expect4j.IOPair;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;

public class BlockingConsumer
extends ConsumerImpl {
    Boolean callerProcessing = Boolean.FALSE;
    boolean foundMore = false;

    public BlockingConsumer(IOPair pair) {
        super(pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BlockingConsumer blockingConsumer;
        char[] cs = new char[256];
        Reader reader = this.pair.getReader();
        ConsumerImpl.log.fine("Starting primary loop");
        while (!this.stopRequested && !this.foundEOF) {
            int length;
            try {
                ConsumerImpl.log.finer("Reading from reader");
                length = reader.read(cs);
            }
            catch (IOException ioe) {
                ConsumerImpl.log.log(Level.FINER, "While checking ready", ioe);
                this.foundEOF = true;
                break;
            }
            if (length == -1) {
                ConsumerImpl.log.fine("Found the EOF");
                ConsumerImpl.log.fine("Current buffer: " + this.buffer.toString());
                this.foundEOF = true;
                break;
            }
            ConsumerImpl.log.finer("Waiting for synch before appending");
            blockingConsumer = this;
            synchronized (blockingConsumer) {
                if (ConsumerImpl.log.isLoggable(Level.FINER)) {
                    String print = new String(cs, 0, length);
                    print = print.replaceAll("\n", "\\\\n");
                    print = print.replaceAll("\r", "\\\\r");
                    ConsumerImpl.log.finer("Appending >>>" + print + "<<<");
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < length; ++i) {
                        sb.append("," + cs[i]);
                    }
                    ConsumerImpl.log.finer("Codes: " + sb.toString());
                }
                this.buffer.append(cs, 0, length);
                ConsumerImpl.log.finest("Waking up who ever if listening");
                this.notify();
            }
        }
        blockingConsumer = this;
        synchronized (blockingConsumer) {
            this.notify();
        }
        if (this.stopRequested) {
            ConsumerImpl.log.info("Stop Requested");
            this.pair.close();
        }
        if (this.foundEOF) {
            ConsumerImpl.log.info("Found EOF to stop while loop");
        }
        ConsumerImpl.log.fine("Leaving primary loop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForBuffer(long timeoutMilli) {
        if (this.foundEOF) {
            ConsumerImpl.log.finer("Wanted to wait for buffer but foundEOF");
            return;
        }
        ConsumerImpl.log.finer("Synching on this to wait");
        BlockingConsumer blockingConsumer = this;
        synchronized (blockingConsumer) {
            try {
                ConsumerImpl.log.finer("Waiting for some additional event");
                if (timeoutMilli > 0L) {
                    this.wait(timeoutMilli);
                } else {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                ConsumerImpl.log.info("Woken up, while waiting for buffer");
            }
        }
    }

    public String pause() {
        String currentBuffer = this.buffer.toString();
        return currentBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(int offset) {
        if (offset < 0) {
            return;
        }
        BlockingConsumer blockingConsumer = this;
        synchronized (blockingConsumer) {
            ConsumerImpl.log.fine("Moving buffer up by " + offset);
            StringBuffer stringBuffer = this.buffer.delete(0, offset);
        }
    }

    public static void main(String[] args) throws Exception {
        final StringBuffer buffer = new StringBuffer("The lazy fox");
        Thread t1 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                StringBuffer stringBuffer = buffer;
                synchronized (stringBuffer) {
                    buffer.delete(0, 4);
                    buffer.append(" in the middle");
                    System.err.println("Middle");
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    buffer.append(" of fall");
                    System.err.println("Fall");
                }
            }
        };
        Thread t2 = new Thread(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                buffer.append(" jump over the fence");
                System.err.println("Fence");
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        System.err.println(buffer);
    }
}

